/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.sigar;

import java.io.File;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.process.local.LocalProcess;
import org.echocat.jomon.process.sigar.SigarFacade;
import org.echocat.jomon.runtime.CollectionUtils;
import org.hyperic.sigar.ProcExe;
import org.hyperic.sigar.SigarException;

@ThreadSafe
public class SigarProcess
implements LocalProcess {
    private final long _pid;
    private final SigarFacade _sigar;
    private volatile boolean _execResolved;
    private volatile boolean _argsResolved;
    private volatile File _executable;
    private List<String> _commandLine;

    public SigarProcess(long pid, @Nonnull SigarFacade sigar) {
        this._pid = pid;
        this._sigar = sigar;
    }

    public Long getId() {
        return this._pid;
    }

    @Override
    @Nullable
    public File getExecutable() {
        this.resolveExecIfNeeded();
        return this._executable;
    }

    @Override
    @Nullable
    public List<String> getArguments() {
        this.resolveArgsIfNeeded();
        return this._commandLine;
    }

    protected void resolveExecIfNeeded() {
        if (!this._execResolved) {
            try {
                ProcExe procExe = this._sigar.getProcExe(this._pid);
                String name = procExe.getName();
                File file = new File(name);
                if (file.isFile()) {
                    this._executable = file;
                }
            }
            catch (SigarException sigarException) {
                // empty catch block
            }
            this._execResolved = true;
        }
    }

    protected void resolveArgsIfNeeded() {
        if (!this._argsResolved) {
            try {
                this._commandLine = CollectionUtils.asImmutableList((Object[])this._sigar.getProcArgs(this._pid));
            }
            catch (SigarException sigarException) {
                // empty catch block
            }
            this._argsResolved = true;
        }
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof SigarProcess)) {
            result = false;
        } else {
            SigarProcess that = (SigarProcess)o;
            result = this._pid == that._pid;
        }
        return result;
    }

    public int hashCode() {
        return (int)(this._pid ^ this._pid >>> 32);
    }

    public String toString() {
        return "Process #" + this._pid;
    }
}

