/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.windows;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.win32.W32APIOptions;
import java.lang.reflect.Field;
import java.util.Map;
import javax.annotation.Nonnull;
import org.echocat.jomon.process.local.ProcessPidResolver;

public class WindowsProcessPidResolver
extends ProcessPidResolver {
    protected static final Class<?> WIN32_PROCESS_CLASS = WindowsProcessPidResolver.findClass("java.lang.Win32Process");
    protected static final Class<?> PROCESS_IMPL_CLASS = WindowsProcessPidResolver.findClass("java.lang.ProcessImpl");
    protected static final Field WIN32_PROCESS_HANDLE_FIELD = WindowsProcessPidResolver.findFieldOf("handle", Long.TYPE, WIN32_PROCESS_CLASS);
    protected static final Field PROCESS_IMPL_HANDLE_FIELD = WindowsProcessPidResolver.findFieldOf("handle", Long.TYPE, PROCESS_IMPL_CLASS);
    private WinNT _winNt;

    @Override
    public long resolvePidOf(@Nonnull Process process) {
        long handleId;
        if (WIN32_PROCESS_CLASS != null && WIN32_PROCESS_HANDLE_FIELD != null && WIN32_PROCESS_CLASS.isInstance(process)) {
            handleId = (Long)this.getFieldValue(WIN32_PROCESS_HANDLE_FIELD, process);
        } else if (PROCESS_IMPL_CLASS != null && PROCESS_IMPL_HANDLE_FIELD != null && PROCESS_IMPL_CLASS.isInstance(process)) {
            handleId = (Long)this.getFieldValue(PROCESS_IMPL_HANDLE_FIELD, process);
        } else {
            throw new IllegalArgumentException("Could not handle: " + process);
        }
        return this._winNt.GetProcessId(this.toHandle(handleId));
    }

    @Nonnull
    protected WinNT.HANDLE toHandle(long handleId) {
        WinNT.HANDLE handle = new WinNT.HANDLE();
        handle.setPointer(Pointer.createConstant((long)handleId));
        return handle;
    }

    @Override
    protected boolean couldHandleThisVirtualMachine() {
        boolean result = Platform.isWindows() ? WIN32_PROCESS_HANDLE_FIELD != null || PROCESS_IMPL_HANDLE_FIELD != null : false;
        return result;
    }

    @Override
    protected void init() {
        this._winNt = (WinNT)Native.loadLibrary(WinNT.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
    }
}

