/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.http.client;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.echocat.jomon.runtime.util.Duration;

public class ClientConnectionManagerFactory {
    private Duration _timeToLife = new Duration("15s");
    private int _maximumNumberOfConnections = 20;
    private int _maximumNumberOfConnectionsPerRoute = 20;
    private SchemeRegistry _schemeRegistry = SchemeRegistryFactory.createDefault();

    @Nonnull
    public ClientConnectionManager create() {
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager(this._schemeRegistry, this._timeToLife.toMilliSeconds(), TimeUnit.MILLISECONDS);
        connectionManager.setDefaultMaxPerRoute(this._maximumNumberOfConnectionsPerRoute);
        connectionManager.setMaxTotal(this._maximumNumberOfConnections);
        return connectionManager;
    }

    @Nonnull
    public Duration getTimeToLife() {
        return this._timeToLife;
    }

    public void setTimeToLife(@Nonnull Duration timeToLife) {
        this._timeToLife = timeToLife;
    }

    @Nonnegative
    public int getMaximumNumberOfConnections() {
        return this._maximumNumberOfConnections;
    }

    public void setMaximumNumberOfConnections(@Nonnegative int maximumNumberOfConnections) {
        this._maximumNumberOfConnections = maximumNumberOfConnections;
    }

    @Nonnegative
    public int getMaximumNumberOfConnectionsPerRoute() {
        return this._maximumNumberOfConnectionsPerRoute;
    }

    public void setMaximumNumberOfConnectionsPerRoute(@Nonnegative int maximumNumberOfConnectionsPerRoute) {
        this._maximumNumberOfConnectionsPerRoute = maximumNumberOfConnectionsPerRoute;
    }

    @Nonnull
    public SchemeRegistry getSchemeRegistry() {
        return this._schemeRegistry;
    }

    public void setSchemeRegistry(@Nonnull SchemeRegistry schemeRegistry) {
        this._schemeRegistry = schemeRegistry;
    }
}

