/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.IO;
import com.jcraft.jsch.Packet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NotifyingIO
extends IO {
    @Nonnull
    private final IO _original;
    @Nullable
    private volatile EventConsumer _eventConsumer;

    public NotifyingIO(@Nonnull IO original) {
        this._original = original;
    }

    public void setOutputStream(OutputStream out) {
        this._original.setOutputStream(out);
    }

    public void setOutputStream(OutputStream out, boolean dontclose) {
        this._original.setOutputStream(out, dontclose);
    }

    public void setExtOutputStream(OutputStream out) {
        this._original.setExtOutputStream(out);
    }

    public void setExtOutputStream(OutputStream out, boolean dontclose) {
        this._original.setExtOutputStream(out, dontclose);
    }

    public void setInputStream(InputStream in) {
        this._original.setInputStream(in);
    }

    public void setInputStream(InputStream in, boolean dontclose) {
        this._original.setInputStream(in, dontclose);
    }

    public void put(Packet p) throws IOException, SocketException {
        this._original.put(p);
    }

    public void put(byte[] array, int begin, int length) throws IOException {
        this._original.put(array, begin, length);
    }

    public void put_ext(byte[] array, int begin, int length) throws IOException {
        this._original.put_ext(array, begin, length);
    }

    public int getByte() throws IOException {
        return this._original.getByte();
    }

    public void getByte(byte[] array) throws IOException {
        this._original.getByte(array);
    }

    public void getByte(byte[] array, int begin, int length) throws IOException {
        this._original.getByte(array, begin, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void out_close() {
        try {
            this._original.out_close();
        }
        finally {
            EventConsumer consumer = this._eventConsumer;
            if (consumer != null) {
                consumer.onClose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this._original.close();
        }
        finally {
            EventConsumer consumer = this._eventConsumer;
            if (consumer != null) {
                consumer.onClose();
            }
        }
    }

    public void setEventConsumer(@Nullable EventConsumer eventConsumer) {
        this._eventConsumer = eventConsumer;
    }

    public static interface EventConsumer {
        public void onClose();
    }
}

