/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.ssh;

import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import org.echocat.jomon.net.ssh.SshProcessRepository;
import org.echocat.jomon.net.ssh.SshSessionGenerator;
import org.echocat.jomon.runtime.util.ResourceUtils;

public abstract class Ssh {
    private static final Ssh INSTANCE = Ssh.createInstance();

    @Nonnull
    public static Ssh getInstance() {
        return INSTANCE;
    }

    @Nonnull
    public static Ssh ssh() {
        return Ssh.getInstance();
    }

    @Nonnull
    public static SshSessionGenerator sessionGenerator() {
        return Ssh.ssh().getSessionGenerator();
    }

    @Nonnull
    public static SshProcessRepository processRepository() {
        return Ssh.ssh().getProcessRepository();
    }

    @Nonnull
    public abstract SshSessionGenerator getSessionGenerator();

    @Nonnull
    public abstract SshProcessRepository getProcessRepository();

    public abstract boolean isAvailable();

    @Nonnull
    protected static Ssh createInstance() {
        Ssh processRepository = null;
        for (Ssh candidate : ServiceLoader.load(Ssh.class)) {
            if (!candidate.isAvailable()) continue;
            processRepository = candidate;
            break;
        }
        if (processRepository == null) {
            throw new IllegalStateException("Could not find any matching implementation of " + Ssh.class.getName() + " for this virtual machine.");
        }
        Ssh.closeOnJvmShutdown(processRepository);
        return processRepository;
    }

    private static void closeOnJvmShutdown(final @Nonnull Ssh processRepository) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ResourceUtils.closeQuietlyIfAutoCloseable((Object)processRepository);
            }
        });
    }
}

