/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.ssh.jsch;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.NotifyingIO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.net.ssh.SshGeneratedProcess;
import org.echocat.jomon.net.ssh.SshGeneratedProcessRequirement;
import org.echocat.jomon.net.ssh.SshProcess;
import org.echocat.jomon.net.ssh.SshProcessUtils;
import org.echocat.jomon.net.ssh.jsch.JschUtils;
import org.echocat.jomon.process.Pty;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.ResourceUtils;

public class JschSshGeneratedProcess
implements SshGeneratedProcess {
    @Nonnull
    private final Lock _lock = new ReentrantLock();
    @Nonnull
    private final Condition _condition = this._lock.newCondition();
    private boolean _closed;
    @Nonnull
    private final SshGeneratedProcessRequirement _requirement;
    @Nonnull
    private final ChannelExec _exec;
    private final boolean _closeContext;
    @Nonnull
    private final SshProcess.Id _id;

    public JschSshGeneratedProcess(@Nonnull SshGeneratedProcessRequirement requirement, @Nonnull ChannelExec exec, @Nonnull SshProcess.Id id, boolean closeContext) throws IOException {
        this._requirement = requirement;
        this._exec = exec;
        this._closeContext = closeContext;
        this._id = id;
        JschUtils.register(new EventConsumerImpl(), (Channel)exec);
    }

    @Nonnull
    public String getExecutable() {
        return (String)this._requirement.getExecutable();
    }

    @Nonnull
    public List<String> getArguments() {
        return this._requirement.getArguments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public int waitFor() throws InterruptedException, IllegalStateException {
        this._lock.lockInterruptibly();
        try {
            if (!this._closed) {
                while (this._exec.isConnected()) {
                    this._condition.await(100L, TimeUnit.MILLISECONDS);
                }
            }
        }
        finally {
            this._lock.unlock();
        }
        while (this._exec.isConnected()) {
            this._exec.disconnect();
            Duration.sleep((String)"10ms");
        }
        return this.exitValue();
    }

    public int exitValue() throws IllegalStateException {
        if (this._exec.isConnected()) {
            throw new IllegalStateException();
        }
        return this._exec.getExitStatus();
    }

    public boolean isAlive() {
        return this._exec.isConnected();
    }

    @Override
    @Nullable
    public Pty getPty() {
        return this._requirement.getPty();
    }

    public boolean isDaemon() {
        return this._requirement.isDaemon();
    }

    @Nonnull
    public SshProcess.Id getId() {
        return this._id;
    }

    @Nonnull
    public OutputStream getStdin() throws IOException {
        return this._exec.getOutputStream();
    }

    @Nonnull
    public InputStream getStdout() throws IOException {
        return this._exec.getInputStream();
    }

    @Nonnull
    public InputStream getStderr() throws IOException {
        return this._exec.getErrStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this._requirement.getPty() != null) {
                OutputStream out = this._exec.getOutputStream();
                out.write(3);
                out.flush();
                this.waitFor();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws IOException {
        try {
            try {
                this._exec.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (this._closeContext) {
                ResourceUtils.closeQuietly((AutoCloseable)this._requirement.getContext());
            }
        }
    }

    public String toString() {
        return SshProcessUtils.getCompleteCommandLineArguments(this.getExecutable(), this.getArguments());
    }

    protected class EventConsumerImpl
    implements NotifyingIO.EventConsumer {
        protected EventConsumerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClose() {
            JschSshGeneratedProcess.this._lock.lock();
            try {
                if (!JschSshGeneratedProcess.this._closed) {
                    JschSshGeneratedProcess.this._closed = true;
                    JschSshGeneratedProcess.this._condition.signalAll();
                }
            }
            finally {
                JschSshGeneratedProcess.this._lock.unlock();
            }
        }
    }
}

