/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.ssh.jsch;

import com.jcraft.jsch.Session;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import org.echocat.jomon.net.ssh.SshRemote;
import org.echocat.jomon.net.ssh.SshSession;
import org.echocat.jomon.runtime.codec.Md5Utils;
import org.echocat.jomon.runtime.reflection.ClassUtils;

public class JschSshSession
implements SshSession {
    private static final Field ID_FIELD = ClassUtils.getFieldOf(Session.class, byte[].class, (String)"session_id", (boolean)false);
    @Nonnull
    private final SshRemote _remote;
    @Nonnull
    private final Session _session;

    public JschSshSession(@Nonnull SshRemote remote, @Nonnull Session session) {
        this._remote = remote;
        this._session = session;
    }

    @Override
    @Nonnull
    public SshRemote getRemote() {
        return this._remote;
    }

    @Nonnull
    public Session getSession() {
        return this._session;
    }

    public String toString() {
        return this.getId() + "@" + this._remote;
    }

    @Override
    public void close() throws IOException {
        this.getSession().disconnect();
    }

    @Nonnull
    public String getId() {
        return Md5Utils.asHexString((byte[])this.getIdAsBytes());
    }

    @Nonnull
    public byte[] getIdAsBytes() {
        try {
            return (byte[])ID_FIELD.get(this.getSession());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not read id of session.", e);
        }
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof JschSshSession)) {
            result = false;
        } else {
            JschSshSession that = (JschSshSession)o;
            result = this.getId().equals(that.getId());
        }
        return result;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

