/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.maven;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.echocat.jomon.maven.MavenEnvironment;
import org.echocat.jomon.maven.MavenProjectWithModules;

public class MavenProjectWithModulesFactory {
    @Nonnull
    public MavenProjectWithModules createFor(@Nonnull MavenEnvironment environment, @Nonnull File pomFile) throws Exception {
        ProjectBuildingRequest request = this.createRequest(environment);
        return this.createProjectBy(environment, pomFile, request);
    }

    @Nonnull
    protected ProjectBuildingRequest createRequest(@Nonnull MavenEnvironment environment) {
        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest();
        request.setLocalRepository(environment.getRequest().getLocalRepository());
        request.setRemoteRepositories(environment.getRequest().getRemoteRepositories());
        request.setProfiles(environment.getRequest().getProfiles());
        request.setSystemProperties(environment.getRequest().getSystemProperties());
        request.setUserProperties(environment.getRequest().getUserProperties());
        request.setRepositorySession(environment.getRepositorySystemSession());
        return request;
    }

    @Nonnull
    protected MavenProjectWithModules createProjectBy(@Nonnull MavenEnvironment environment, @Nonnull File pomFile, @Nonnull ProjectBuildingRequest request) throws Exception {
        List results = environment.getProjectBuilder().build(Arrays.asList(pomFile), true, request);
        return this.resultsToProject(pomFile, results);
    }

    @Nonnull
    protected MavenProjectWithModules resultsToProject(@Nonnull File basePomFile, @Nonnull List<ProjectBuildingResult> results) throws Exception {
        HashMap<MavenProject, MavenProjectWithModules> projectToProjectWithModules = new HashMap<MavenProject, MavenProjectWithModules>();
        for (ProjectBuildingResult result : results) {
            if (!result.getProblems().isEmpty()) {
                throw new ProjectBuildingException(results);
            }
            MavenProjectWithModules projectWithModules = this.getMavenProjectWithModules(result, projectToProjectWithModules);
            this.resolveModulesFor(projectWithModules, result, results, projectToProjectWithModules);
        }
        return this.selectBaseProject(basePomFile.getCanonicalFile(), projectToProjectWithModules);
    }

    private MavenProjectWithModules selectBaseProject(File by, Map<MavenProject, MavenProjectWithModules> from) throws Exception {
        MavenProjectWithModules result = null;
        for (Map.Entry<MavenProject, MavenProjectWithModules> projectAndProjectWithModules : from.entrySet()) {
            MavenProject project = projectAndProjectWithModules.getKey();
            if (project.getFile() == null || !by.equals(project.getFile().getCanonicalFile())) continue;
            result = projectAndProjectWithModules.getValue();
            break;
        }
        if (result == null) {
            throw new IllegalStateException("Could not find any project for base pom '" + by + "' in " + from.values() + ".");
        }
        return result;
    }

    @Nonnull
    protected void resolveModulesFor(@Nonnull MavenProjectWithModules of, @Nonnull ProjectBuildingResult forResult, @Nonnull List<ProjectBuildingResult> fromResults, @Nonnull Map<MavenProject, MavenProjectWithModules> withProjectToProjectWithModules) throws Exception {
        block0: for (ProjectBuildingResult result : fromResults) {
            if (!result.getProblems().isEmpty()) {
                throw new ProjectBuildingException(fromResults);
            }
            for (String moduleName : forResult.getProject().getModules()) {
                File pomFile = result.getPomFile();
                File expectedFile = new File(forResult.getPomFile().getParentFile(), moduleName + File.separator + pomFile.getName());
                if (!expectedFile.getCanonicalFile().equals(pomFile.getCanonicalFile())) continue;
                of.addModule(this.getMavenProjectWithModules(result, withProjectToProjectWithModules));
                continue block0;
            }
        }
    }

    @Nonnull
    protected MavenProjectWithModules getMavenProjectWithModules(@Nonnull ProjectBuildingResult forResult, @Nonnull Map<MavenProject, MavenProjectWithModules> fromProjectToProjectWithModules) {
        MavenProject project = forResult.getProject();
        MavenProjectWithModules projectWithModules = fromProjectToProjectWithModules.get(project);
        if (projectWithModules == null) {
            projectWithModules = new MavenProjectWithModules(project);
            fromProjectToProjectWithModules.put(project, projectWithModules);
        }
        return projectWithModules;
    }
}

