/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.spring.ApplicationContextGenerator;
import org.echocat.jomon.spring.DefaultApplicationContextGenerator;

public class ApplicationContextGenerators {
    @Nonnull
    private static final Iterable<ApplicationContextGenerator> ALL = ApplicationContextGenerators.loadAll();
    @Nonnull
    private static final ApplicationContextGenerator DEFAULT = ApplicationContextGenerators.loadDefaultOf(ALL);

    private ApplicationContextGenerators() {
    }

    @Nonnull
    public static ApplicationContextGenerator getDefault() {
        return DEFAULT;
    }

    @Nonnull
    public static ApplicationContextGenerator applicationContextGenerator() {
        return ApplicationContextGenerators.getDefault();
    }

    @Nonnull
    public static Iterable<ApplicationContextGenerator> getAll() {
        return ALL;
    }

    @Nonnull
    private static Iterable<ApplicationContextGenerator> loadAll() {
        ArrayList<DefaultApplicationContextGenerator> result = new ArrayList<DefaultApplicationContextGenerator>();
        CollectionUtils.addAll(result, ServiceLoader.load(ApplicationContextGenerator.class));
        result.add(DefaultApplicationContextGenerator.getInstance());
        return CollectionUtils.asImmutableList(result);
    }

    @Nonnull
    private static ApplicationContextGenerator loadDefaultOf(Iterable<ApplicationContextGenerator> applicationGenerators) {
        Iterator<ApplicationContextGenerator> i = applicationGenerators.iterator();
        return i.next();
    }
}

