/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.spring.ApplicationGenerator;
import org.echocat.jomon.spring.DefaultApplicationGenerator;

public class ApplicationGenerators {
    @Nonnull
    private static final Iterable<ApplicationGenerator> ALL = ApplicationGenerators.loadAll();
    @Nonnull
    private static final ApplicationGenerator DEFAULT = ApplicationGenerators.loadDefaultOf(ALL);

    private ApplicationGenerators() {
    }

    @Nonnull
    public static ApplicationGenerator getDefault() {
        return DEFAULT;
    }

    @Nonnull
    public static ApplicationGenerator applicationGenerator() {
        return ApplicationGenerators.getDefault();
    }

    @Nonnull
    public static Iterable<ApplicationGenerator> getAll() {
        return ALL;
    }

    @Nonnull
    private static Iterable<ApplicationGenerator> loadAll() {
        ArrayList<DefaultApplicationGenerator> result = new ArrayList<DefaultApplicationGenerator>();
        CollectionUtils.addAll(result, ServiceLoader.load(ApplicationGenerator.class));
        result.add(DefaultApplicationGenerator.getInstance());
        return CollectionUtils.asImmutableList(result);
    }

    @Nonnull
    private static ApplicationGenerator loadDefaultOf(Iterable<ApplicationGenerator> applicationGenerators) {
        Iterator<ApplicationGenerator> i = applicationGenerators.iterator();
        return i.next();
    }
}

