/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring;

import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.ManifestInformationFactory;
import org.echocat.jomon.runtime.io.UrlUtils;
import org.echocat.jomon.runtime.logging.Log4JUtils;
import org.echocat.jomon.spring.Application;
import org.echocat.jomon.spring.ApplicationGenerators;
import org.echocat.jomon.spring.ApplicationRequirement;
import org.echocat.jomon.spring.ClassBasedApplicationRequirement;
import org.echocat.jomon.spring.DefaultApplicationGenerator;
import org.echocat.jomon.spring.PathBasedApplicationRequirement;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class Boot {
    @Nonnull
    private static ManifestInformationFactory c_informationFactory;
    @Nonnull
    private static String c_applicationName;

    public static void main(String[] args) {
        if (args == null || args.length != 1 && args.length != 2) {
            System.err.println("java -cp <?> " + Boot.class.getName() + " <boot bean.xml in classpath> [log4j configuration in classpath]");
            System.exit(1);
        } else {
            PathBasedApplicationRequirement requirement = PathBasedApplicationRequirement.applicationFor(Boot.class.getClassLoader(), args[0]);
            if (args.length > 1) {
                requirement.setLog4jConfigurationInClassPath(args[1]);
            }
            Boot.start(requirement);
        }
    }

    @Nonnull
    public static Application start(@Nonnull ApplicationRequirement requirement) {
        Boot.configureInformationFactory(requirement);
        Boot.configureLog4j(requirement);
        return Boot.startApplication(requirement);
    }

    @Nonnull
    public static Application startApplication(@Nonnull ApplicationRequirement requirement) {
        return (Application)ApplicationGenerators.applicationGenerator().generate(requirement);
    }

    @Nonnull
    public static ManifestInformationFactory getInformationFactory() {
        return c_informationFactory;
    }

    @Deprecated
    @Nonnull
    public static String getApplicationName() {
        return c_applicationName;
    }

    protected static void configureInformationFactory(@Nonnull ApplicationRequirement requirement) {
        c_informationFactory = new ManifestInformationFactory(requirement.getBeanXmlInClassPath(), requirement.getClassLoader());
        c_applicationName = DefaultApplicationGenerator.getTitleFor(requirement, c_informationFactory);
    }

    protected static void configureLog4j(@Nonnull ApplicationRequirement requirement) {
        String log4jConfigurationInClassPath = requirement.getLog4jConfigurationInClassPath();
        ClassLoader classLoader = requirement.getClassLoader();
        Log4JUtils.configureRuntime((URL)(log4jConfigurationInClassPath != null ? classLoader.getResource(log4jConfigurationInClassPath) : Boot.class.getResource("default.log4j.xml")));
    }

    @Deprecated
    @Nonnull
    public static ConfigurableApplicationContext start(@Nonnull Class<?> reference, @Nonnull String bootBeanXmlFileName) {
        return Boot.start(ClassBasedApplicationRequirement.applicationBasedOn(reference).withBeanXmlFileName(bootBeanXmlFileName)).getApplicationContext();
    }

    @Deprecated
    @Nonnull
    public static ConfigurableApplicationContext start(@Nonnull Class<?> reference, @Nonnull String bootBeanXmlFileName, @Nullable String log4jConfigurationFileName) {
        return Boot.start(ClassBasedApplicationRequirement.applicationBasedOn(reference).withBeanXmlFileName(bootBeanXmlFileName).withLog4jConfigurationFileName(log4jConfigurationFileName)).getApplicationContext();
    }

    @Deprecated
    @Nonnull
    public static ConfigurableApplicationContext start(@Nonnull String bootBeanXmlInClassPath) {
        return Boot.start(PathBasedApplicationRequirement.applicationFor(Boot.class.getClassLoader(), bootBeanXmlInClassPath)).getApplicationContext();
    }

    @Deprecated
    @Nonnull
    public static ConfigurableApplicationContext start(@Nonnull String bootBeanXmlInClassPath, @Nullable String log4jConfigurationInClassPath) {
        return Boot.start(PathBasedApplicationRequirement.applicationFor(Boot.class.getClassLoader(), bootBeanXmlInClassPath).withLog4jConfigurationInClassPath(log4jConfigurationInClassPath)).getApplicationContext();
    }

    @Deprecated
    @Nonnull
    public static ConfigurableApplicationContext startComponent(@Nonnull String bootBeanXmlInClassPath, @Nonnull String applicationName) {
        return Boot.start(PathBasedApplicationRequirement.applicationFor(Boot.class.getClassLoader(), bootBeanXmlInClassPath).withDefaultApplicationName(applicationName)).getApplicationContext();
    }

    @Deprecated
    @Nonnull
    public static ConfigurableApplicationContext startComponent(@Nullable ApplicationContext parent, @Nonnull String bootBeanXmlInClassPath, @Nonnull String applicationName) {
        return Boot.start(((PathBasedApplicationRequirement)PathBasedApplicationRequirement.applicationFor(Boot.class.getClassLoader(), bootBeanXmlInClassPath).withDefaultApplicationName(applicationName)).withParentApplicationContext(parent)).getApplicationContext();
    }

    private Boot() {
    }

    static {
        UrlUtils.registerUrlStreamHandlerIfNeeded();
        c_informationFactory = new ManifestInformationFactory(Boot.class);
        c_applicationName = Boot.class.getName();
    }
}

