/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.spring.ApplicationRequirementSupport;

public class ClassBasedApplicationRequirement
extends ApplicationRequirementSupport<ClassBasedApplicationRequirement> {
    @Nonnull
    private final Class<?> _reference;
    @Nonnull
    private ClassLoader _classLoader;
    @Nonnull
    private String _beanXmlFileName = "main.xml";
    @Nullable
    private String _log4jConfigurationFileName;

    @Nonnull
    public static ClassBasedApplicationRequirement applicationBasedOn(@Nonnull Class<?> reference) {
        return new ClassBasedApplicationRequirement(reference);
    }

    public ClassBasedApplicationRequirement(@Nonnull Class<?> reference) {
        this._reference = reference;
        this._classLoader = reference.getClassLoader();
    }

    @Override
    @Nonnull
    public String getBeanXmlInClassPath() {
        return this.fullElementPath(this._reference, this._beanXmlFileName);
    }

    @Override
    @Nullable
    public String getLog4jConfigurationInClassPath() {
        String log4jConigurationFileName = this._log4jConfigurationFileName;
        return log4jConigurationFileName != null ? this.fullElementPath(this._reference, log4jConigurationFileName) : null;
    }

    @Override
    @Nonnull
    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    @Nonnull
    public Class<?> getReference() {
        return this._reference;
    }

    public void setBeanXmlFileName(@Nonnull String beanXmlFileName) {
        this._beanXmlFileName = beanXmlFileName;
    }

    @Nonnull
    public String getBeanXmlFileName() {
        return this._beanXmlFileName;
    }

    public void setClassLoader(@Nonnull ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    @Nullable
    public String getLog4jConfigurationFileName() {
        return this._log4jConfigurationFileName;
    }

    public void setLog4jConfigurationFileName(@Nullable String log4jConfigurationFileName) {
        this._log4jConfigurationFileName = log4jConfigurationFileName;
    }

    @Nonnull
    public ClassBasedApplicationRequirement withClassLoader(@Nonnull ClassLoader classLoader) {
        this.setClassLoader(classLoader);
        return (ClassBasedApplicationRequirement)this.thisObject();
    }

    @Nonnull
    public ClassBasedApplicationRequirement withLog4jConfigurationFileName(@Nonnull String fileName) {
        this.setLog4jConfigurationFileName(fileName);
        return (ClassBasedApplicationRequirement)this.thisObject();
    }

    @Nonnull
    public ClassBasedApplicationRequirement withBeanXmlFileName(@Nonnull String fileName) {
        this.setBeanXmlFileName(fileName);
        return (ClassBasedApplicationRequirement)this.thisObject();
    }

    @Nonnull
    protected String fullElementPath(@Nonnull Class<?> reference, @Nonnull String element) {
        return reference.getPackage().getName().replace('.', '/') + '/' + element;
    }
}

