/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring;

import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.echocat.jomon.spring.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

@ThreadSafe
public class DefaultApplication
implements Application {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(DefaultApplication.class);
    @Nonnull
    private final ConfigurableApplicationContext _applicationContext;
    @Nonnull
    private final String _title;
    @Nullable
    private final Thread _shutdownHook;

    public DefaultApplication(@Nonnull ConfigurableApplicationContext applicationContext, @Nonnull String title) {
        this._applicationContext = applicationContext;
        this._title = title;
        this._shutdownHook = new Thread(this._title + " destroyer"){

            @Override
            public void run() {
                ResourceUtils.closeQuietly((AutoCloseable)DefaultApplication.this);
            }
        };
        if (applicationContext instanceof AbstractApplicationContext) {
            this.setShutdownHook(this._shutdownHook, (AbstractApplicationContext)applicationContext);
        }
        Runtime.getRuntime().addShutdownHook(this._shutdownHook);
    }

    @Override
    @Nonnull
    public ConfigurableApplicationContext getApplicationContext() {
        return this._applicationContext;
    }

    @Override
    @Nonnull
    public String getTitle() {
        return this._title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        ConfigurableApplicationContext configurableApplicationContext = this._applicationContext;
        synchronized (configurableApplicationContext) {
            try {
                if (this._applicationContext.isActive()) {
                    LOG.info("Stopping " + this._title + "...");
                    ((DisposableBean)this._applicationContext).destroy();
                    LOG.info("Stopping " + this._title + "... DONE!");
                }
            }
            finally {
                Runtime.getRuntime().removeShutdownHook(this._shutdownHook);
            }
        }
    }

    public String toString() {
        return this._title;
    }

    protected void setShutdownHook(@Nonnull Thread thread, @Nonnull AbstractApplicationContext to) {
        try {
            Field field = AbstractApplicationContext.class.getDeclaredField("shutdownHook");
            field.setAccessible(true);
            field.set(to, thread);
        }
        catch (Exception e) {
            LOG.warn("Could not register shutdownHook at " + to + " this could cause to much memory consume of the JVM.", (Throwable)e);
        }
    }
}

