/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring;

import javax.annotation.Nonnull;
import org.echocat.jomon.spring.ApplicationContextGenerator;
import org.echocat.jomon.spring.ApplicationRequirement;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class DefaultApplicationContextGenerator
implements ApplicationContextGenerator {
    @Nonnull
    private static final DefaultApplicationContextGenerator INSTANCE = new DefaultApplicationContextGenerator();

    @Nonnull
    public static DefaultApplicationContextGenerator getInstance() {
        return INSTANCE;
    }

    @Nonnull
    public static DefaultApplicationContextGenerator defaultApplicationContextGenerator() {
        return DefaultApplicationContextGenerator.getInstance();
    }

    @Nonnull
    public ConfigurableApplicationContext generate(@Nonnull ApplicationRequirement requirement) {
        AbstractApplicationContext result = this.newInstance(requirement);
        result.setClassLoader(requirement.getClassLoader());
        return result;
    }

    @Nonnull
    protected AbstractApplicationContext newInstance(@Nonnull ApplicationRequirement requirement) {
        return new ClassPathXmlApplicationContext(new String[]{requirement.getBeanXmlInClassPath()}, false, requirement.getParentApplicationContext());
    }
}

