/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.runtime.ManifestInformationFactory;
import org.echocat.jomon.runtime.concurrent.StopWatch;
import org.echocat.jomon.spring.Application;
import org.echocat.jomon.spring.ApplicationGenerator;
import org.echocat.jomon.spring.ApplicationRequirement;
import org.echocat.jomon.spring.ContextLoadThreadGroup;
import org.echocat.jomon.spring.DefaultApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;

@ThreadSafe
public class DefaultApplicationGenerator
implements ApplicationGenerator {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(DefaultApplicationGenerator.class);
    @Nonnull
    private static final DefaultApplicationGenerator INSTANCE = new DefaultApplicationGenerator();

    @Nonnull
    public static DefaultApplicationGenerator getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Application generate(@Nonnull ApplicationRequirement requirement) {
        String title = this.getTitleFor(requirement);
        StopWatch stopWatch = new StopWatch();
        LOG.info("Starting " + title + "...");
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)requirement.getApplicationContextGenerator().generate(requirement);
        boolean success = false;
        boolean applicationContextStarted = false;
        try {
            DefaultApplication application = new DefaultApplication(applicationContext, title);
            applicationContext.refresh();
            applicationContextStarted = true;
            this.waitForContextLoadThreads(applicationContext);
            LOG.info("Starting " + title + "... DONE! (after: " + stopWatch + ")");
            success = true;
            DefaultApplication defaultApplication = application;
            return defaultApplication;
        }
        finally {
            if (applicationContextStarted && !success) {
                applicationContext.close();
            }
        }
    }

    protected void waitForContextLoadThreads(@Nonnull ConfigurableApplicationContext applicationContext) {
        try {
            for (ContextLoadThreadGroup contextLoadThreadGroup : applicationContext.getBeansOfType(ContextLoadThreadGroup.class).values()) {
                contextLoadThreadGroup.join();
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    @Nonnull
    protected String getTitleFor(@Nonnull ApplicationRequirement requirement) {
        ManifestInformationFactory manifestInformationFactory = new ManifestInformationFactory(requirement.getBeanXmlInClassPath(), requirement.getClassLoader());
        return DefaultApplicationGenerator.getTitleFor(requirement, manifestInformationFactory);
    }

    @Nonnull
    protected static String getTitleFor(@Nonnull ApplicationRequirement requirement, @Nonnull ManifestInformationFactory manifestInformationFactory) {
        String title = manifestInformationFactory.getApplicationInfoString();
        return title != null ? title : requirement.getDefaultTitle();
    }
}

