/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Address;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SRVRecord;

public class RecordUtils {
    public static final int DEFAULT_TTL = 3600;

    @Nonnull
    public static SRVRecord srv(@Nonnull String name, @Nonnegative int priority, @Nonnegative int weight, @Nonnegative int port, @Nonnull String target) {
        return RecordUtils.srv(name, 3600L, priority, weight, port, target);
    }

    @Nonnull
    public static SRVRecord srv(@Nonnull String name, @Nonnegative long ttl, @Nonnegative int priority, @Nonnegative int weight, @Nonnegative int port, @Nonnull String target) {
        return RecordUtils.srv(Name.fromConstantString((String)name), ttl, priority, weight, port, Name.fromConstantString((String)target));
    }

    @Nonnull
    public static SRVRecord srv(@Nonnull Name name, @Nonnegative long ttl, @Nonnegative int priority, @Nonnegative int weight, @Nonnegative int port, @Nonnull Name target) {
        return new SRVRecord(name, 1, ttl, priority, weight, port, target);
    }

    @Nonnull
    public static ARecord a(@Nonnull String name, @Nonnull String ipv4) {
        return RecordUtils.a(name, 3600L, ipv4);
    }

    @Nonnull
    public static ARecord a(@Nonnull String name, @Nonnegative long ttl, @Nonnull String ipv4) {
        return RecordUtils.a(name, ttl, Address.toByteArray((String)ipv4, (int)1));
    }

    @Nonnull
    public static ARecord a(@Nonnull String name, @Nonnegative long ttl, @Nonnull byte[] address) {
        try {
            return RecordUtils.a(Name.fromConstantString((String)name), ttl, InetAddress.getByAddress(address));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Given address is invalid: " + Arrays.toString(address), e);
        }
    }

    @Nonnull
    public static ARecord a(@Nonnull Name name, @Nonnegative long ttl, @Nonnull InetAddress address) {
        return new ARecord(name, 1, ttl, address);
    }

    @Nonnull
    public static SOARecord soa(@Nonnull String name, @Nonnull String host, @Nonnegative long serial) {
        return RecordUtils.soa(name, 3600L, host, serial);
    }

    @Nonnull
    public static SOARecord soa(@Nonnull String name, @Nonnegative long ttl, @Nonnull String host, @Nonnegative long serial) {
        return RecordUtils.soa(name, ttl, host, serial, ttl, ttl * 2L, ttl * 500L, ttl);
    }

    @Nonnull
    public static SOARecord soa(@Nonnull String name, @Nonnegative long ttl, @Nonnull String host, @Nonnegative long serial, @Nonnegative long refresh, @Nonnegative long retry, @Nonnegative long expire, @Nonnegative long minimum) {
        return RecordUtils.soa(name, ttl, host, "hostmaster." + host, serial, refresh, retry, expire, minimum);
    }

    @Nonnull
    public static SOARecord soa(@Nonnull String name, @Nonnegative long ttl, @Nonnull String host, @Nonnull String admin, @Nonnegative long serial, @Nonnegative long refresh, @Nonnegative long retry, @Nonnegative long expire, @Nonnegative long minimum) {
        return RecordUtils.soa(Name.fromConstantString((String)name), ttl, Name.fromConstantString((String)host), Name.fromConstantString((String)admin), serial, refresh, retry, expire, minimum);
    }

    @Nonnull
    public static SOARecord soa(@Nonnull Name name, @Nonnegative long ttl, @Nonnull Name host, @Nonnull Name admin, @Nonnegative long serial, @Nonnegative long refresh, @Nonnegative long retry, @Nonnegative long expire, @Nonnegative long minimum) {
        return new SOARecord(name, 1, ttl, host, admin, serial, refresh, retry, expire, minimum);
    }

    @Nonnull
    public static NSRecord ns(@Nonnull String name, @Nonnegative long ttl, @Nonnull String target) {
        return RecordUtils.ns(Name.fromConstantString((String)name), ttl, Name.fromConstantString((String)target));
    }

    @Nonnull
    public static NSRecord ns(@Nonnull String name, @Nonnull String target) {
        return RecordUtils.ns(name, 3600L, target);
    }

    @Nonnull
    public static NSRecord ns(@Nonnull Name name, @Nonnegative long ttl, @Nonnull Name target) {
        return new NSRecord(name, 1, ttl, target);
    }

    private RecordUtils() {
    }
}

