/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections15.map.LRUMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jomon.resources.ClassPathResource;
import org.echocat.jomon.resources.ResourceType;
import org.echocat.jomon.resources.ResourceTypeProvider;
import org.echocat.jomon.runtime.system.DynamicClassLoader;

public class ClassPathResourceFactory {
    private final Map<ClassLoader, Map<String, ClassPathResource>> _classLoaderToEntriesCache = new WeakHashMap<ClassLoader, Map<String, ClassPathResource>>();
    private final ResourceTypeProvider _resourceTypeProvider;
    private int _cachedEntriesPerClassLoader = 1000;

    public ClassPathResourceFactory(@Nonnull ResourceTypeProvider resourceTypeProvider) {
        this._resourceTypeProvider = resourceTypeProvider;
    }

    @Nonnull
    public ClassPathResource getFor(@Nonnull String path, @Nonnull ClassLoader classLoader) {
        return this.getFor(path, null, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ClassPathResource getFor(@Nonnull String path, @Nullable ResourceType resourceType, @Nonnull ClassLoader classLoader) {
        ClassPathResource result;
        ResourceType originalResourceType = this.getResourceTypeOf(path);
        if (classLoader instanceof DynamicClassLoader && ((DynamicClassLoader)classLoader).isDynamic()) {
            result = new ClassPathResource(path, originalResourceType, classLoader);
        } else {
            Map<String, ClassPathResource> pathToResource = this.getPathToResourceCacheFor(classLoader);
            result = pathToResource.get(path);
            Map<String, ClassPathResource> map = pathToResource;
            synchronized (map) {
                if (result == null) {
                    result = new ClassPathResource(path, originalResourceType, classLoader);
                    pathToResource.put(path, result);
                }
            }
        }
        return resourceType == null || resourceType.equals(originalResourceType) ? result : new OverridingTypeClassPathResource(resourceType, result);
    }

    @Nonnull
    protected ResourceType getResourceTypeOf(@Nonnull String path) {
        ResourceType resourceType;
        String extension = FilenameUtils.getExtension((String)path);
        if (StringUtils.isEmpty((CharSequence)extension)) {
            throw new IllegalArgumentException("Found an path without any extension: " + path);
        }
        try {
            resourceType = this._resourceTypeProvider.getBy(extension);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Found an path with an unknown extension: " + path, e);
        }
        return resourceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected Map<String, ClassPathResource> getPathToResourceCacheFor(@Nonnull ClassLoader classLoader) {
        LRUMap pathToResource;
        Map<ClassLoader, Map<String, ClassPathResource>> map = this._classLoaderToEntriesCache;
        synchronized (map) {
            pathToResource = this._classLoaderToEntriesCache.get(classLoader);
            if (pathToResource == null) {
                pathToResource = new LRUMap(this._cachedEntriesPerClassLoader);
                this._classLoaderToEntriesCache.put(classLoader, (Map<String, ClassPathResource>)pathToResource);
            }
        }
        return pathToResource;
    }

    public int getCachedEntriesPerClassLoader() {
        return this._cachedEntriesPerClassLoader;
    }

    public void setCachedEntriesPerClassLoader(int cachedEntriesPerClassLoader) {
        this._cachedEntriesPerClassLoader = cachedEntriesPerClassLoader;
    }

    protected static class OverridingTypeClassPathResource
    extends ClassPathResource {
        @Nonnull
        private final ClassPathResource _original;

        public OverridingTypeClassPathResource(@Nonnull ResourceType overridingType, @Nonnull ClassPathResource original) {
            super(original.getUri(), overridingType, original.getClassLoader());
            this._original = original;
        }

        @Override
        @Nonnull
        public InputStream openInputStream() throws IOException {
            return this._original.openInputStream();
        }

        @Override
        @Nonnull
        public byte[] getMd5() throws IOException {
            return this._original.getMd5();
        }

        @Override
        public long getSize() throws IOException {
            return this._original.getSize();
        }

        @Override
        public Date getLastModified() throws IOException {
            return this._original.getLastModified();
        }

        @Override
        public boolean isExisting() throws IOException {
            return this._original.isExisting();
        }

        @Override
        @Nonnull
        public String getUri() {
            return this._original.getUri();
        }

        @Override
        public boolean isGenerated() throws IOException {
            return this._original.isGenerated();
        }

        @Override
        @Nonnull
        public URL getPrivateUrl() throws IOException {
            return this._original.getPrivateUrl();
        }

        @Override
        @Nonnull
        public String getName() {
            return this._original.getName();
        }
    }
}

