/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.io.IOUtils;
import org.echocat.jomon.resources.Resource;
import org.echocat.jomon.resources.ResourceType;

@NotThreadSafe
public abstract class ResourceGenerator
extends OutputStream {
    private final Resource _originalResource;
    private final ResourceType _type;
    private final String _name;
    private Resource _resultResource;
    private boolean _dropped;

    protected ResourceGenerator(@Nonnull Resource originalResource) throws IOException {
        this(originalResource, null);
    }

    protected ResourceGenerator(@Nonnull Resource originalResource, @Nullable String name) throws IOException {
        this(originalResource.getType(), originalResource, name);
    }

    protected ResourceGenerator(@Nonnull ResourceType type) throws IOException {
        this(type, null);
    }

    protected ResourceGenerator(@Nonnull ResourceType type, @Nullable String name) throws IOException {
        this(type, null, name);
    }

    protected ResourceGenerator(@Nonnull ResourceType type, @Nullable Resource originalResource, @Nullable String name) throws IOException {
        this._type = type;
        this._originalResource = originalResource;
        this._name = name;
    }

    @Nonnull
    public Resource getTemporaryBufferedResource() throws IOException {
        if (this._dropped) {
            throw new IOException("This resources was dropped.");
        }
        if (this._resultResource == null) {
            this.close();
            this._resultResource = this.generateResource();
        }
        return this._resultResource;
    }

    protected abstract Resource generateResource() throws IOException;

    protected abstract OutputStream getOutputStream() throws IOException;

    @Nullable
    protected Resource getOriginalResource() {
        return this._originalResource;
    }

    @Nonnull
    protected ResourceType getType() {
        return this._type;
    }

    @Nullable
    protected String getName() {
        return this._name;
    }

    @Override
    public void write(int b) throws IOException {
        this.getOutputStream().write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.getOutputStream().write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.getOutputStream().write(b);
    }

    @Override
    public void flush() throws IOException {
        this.getOutputStream().flush();
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            IOUtils.closeQuietly((OutputStream)this);
        }
        finally {
            super.finalize();
        }
    }

    public void drop() throws IOException {
        this._dropped = true;
        this.close();
    }
}

