/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jomon.resources.Resource;
import org.echocat.jomon.resources.ResourceRequestUriGenerator;

public class RotatingDomainResourceRequestUriGenerator
implements ResourceRequestUriGenerator {
    private final ResourceRequestUriGenerator _delegate;
    private URI _baseUri;
    private int _hostCount = 10;

    public RotatingDomainResourceRequestUriGenerator(@Nonnull ResourceRequestUriGenerator delegate) {
        this._delegate = delegate;
    }

    public URI getBaseUri() {
        return this._baseUri;
    }

    public void setBaseUri(URI baseUri) {
        if (!(baseUri == null || StringUtils.isEmpty((CharSequence)baseUri.getRawFragment()) && StringUtils.isEmpty((CharSequence)baseUri.getRawQuery()))) {
            throw new IllegalArgumentException("Provided baseUri has a fragment and/or query.");
        }
        this._baseUri = baseUri;
    }

    @Nonnegative
    public int getHostCount() {
        return this._hostCount;
    }

    public void setHostCount(@Nonnegative int hostCount) {
        this._hostCount = hostCount;
    }

    @Override
    @Nonnull
    public String generate(@Nonnull Resource forResource) throws IOException {
        String result;
        String original = this._delegate.generate(forResource);
        URI baseUri = this._baseUri;
        if (baseUri != null) {
            String prefix = baseUri.toString().replace("$hostNumber$", this.hostNumberValueFor(forResource));
            result = prefix + original;
        } else {
            result = original;
        }
        return result;
    }

    @Nonnull
    protected String hostNumberValueFor(@Nonnull Resource resource) throws IOException {
        int hashCode = Arrays.hashCode(resource.getMd5());
        int normalizedHashCode = hashCode >= 0 ? hashCode : hashCode * -1;
        return Integer.toString(normalizedHashCode % this._hostCount + 1);
    }
}

