/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.mail;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Message;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.ArrayUtils;
import org.echocat.jomon.runtime.ImmutableMimeType;
import org.echocat.jomon.runtime.StringUtils;

public class Mail {
    private InternetAddress _sender;
    private final Map<Message.RecipientType, List<InternetAddress>> _recipients = new HashMap<Message.RecipientType, List<InternetAddress>>();
    private final Map<ImmutableMimeType, String> _body = new HashMap<ImmutableMimeType, String>();
    private String _subject;

    @Nonnull
    public static Mail mail() {
        return new Mail();
    }

    @Nonnull
    public Mail withRecipients(@Nonnull Message.RecipientType type, InternetAddress ... recipients) {
        if (!ArrayUtils.isEmpty((Object[])recipients)) {
            List<InternetAddress> addresses = this._recipients.get(type);
            if (addresses == null) {
                addresses = new ArrayList<InternetAddress>();
                this._recipients.put(type, addresses);
            }
            Collections.addAll(addresses, recipients);
        }
        return this.thisInstance();
    }

    @Nonnull
    public Mail withRecipients(InternetAddress ... recipients) {
        return this.withRecipients(Message.RecipientType.TO, recipients);
    }

    @Nonnull
    public Mail withCcs(InternetAddress ... recipients) {
        return this.withRecipients(Message.RecipientType.CC, recipients);
    }

    @Nonnull
    public Mail withBccs(InternetAddress ... recipients) {
        return this.withRecipients(Message.RecipientType.BCC, recipients);
    }

    @Nonnull
    public Mail withRecipients(@Nonnull Message.RecipientType type, String ... recipients) {
        if (!ArrayUtils.isEmpty((Object[])recipients)) {
            ArrayList recipientsAsAddress = new ArrayList(recipients.length);
            for (int i = 0; i < recipients.length; ++i) {
                try {
                    Collections.addAll(recipientsAsAddress, InternetAddress.parse((String)recipients[i], (boolean)true));
                    continue;
                }
                catch (AddressException e) {
                    throw new IllegalArgumentException("Illegal recipient: " + recipients[i], e);
                }
            }
            this.withRecipients(type, recipientsAsAddress.toArray(new InternetAddress[recipientsAsAddress.size()]));
        }
        return this.thisInstance();
    }

    @Nonnull
    public Mail withRecipients(String ... recipients) {
        return this.withRecipients(Message.RecipientType.TO, recipients);
    }

    @Nonnull
    public Mail withCcs(String ... recipients) {
        return this.withRecipients(Message.RecipientType.CC, recipients);
    }

    @Nonnull
    public Mail withBccs(String ... recipients) {
        return this.withRecipients(Message.RecipientType.BCC, recipients);
    }

    @Nonnull
    public Mail withRecipient(@Nonnull Message.RecipientType type, @Nonnull String address, @Nullable String personal) {
        return this.withRecipients(type, this.toInternetAddress(address, personal));
    }

    @Nonnull
    public Mail withRecipient(@Nonnull String address, @Nullable String personal) {
        return this.withRecipient(Message.RecipientType.TO, address, personal);
    }

    @Nonnull
    public Mail withRecipient(@Nonnull InternetAddress internetAddress) {
        return this.withRecipient(Message.RecipientType.TO, internetAddress.getAddress(), internetAddress.getPersonal());
    }

    @Nonnull
    public Mail withCc(@Nonnull String address, @Nullable String personal) {
        return this.withRecipient(Message.RecipientType.CC, address, personal);
    }

    @Nonnull
    public Mail withBcc(@Nonnull String address, @Nullable String personal) {
        return this.withRecipient(Message.RecipientType.BCC, address, personal);
    }

    @Nonnull
    public Mail withBody(@Nonnull ImmutableMimeType type, @Nonnull String body) {
        this._body.put(type, body);
        return this.thisInstance();
    }

    @Nonnull
    public Mail withTextBody(@Nonnull String textBody) {
        return this.withBody(ImmutableMimeType.TEXT_PLAIN, textBody);
    }

    @Nonnull
    public Mail withHtmlBody(@Nonnull String textBody) {
        return this.withBody(ImmutableMimeType.TEXT_HTML, textBody);
    }

    @Nonnull
    public Mail withSubject(@Nonnull String subject) {
        this._subject = subject;
        return this.thisInstance();
    }

    @Nonnull
    public Mail withSender(@Nonnull InternetAddress sender) {
        this._sender = sender;
        return this.thisInstance();
    }

    @Nonnull
    public Mail withSender(@Nonnull String address, @Nullable String personal) {
        return this.withSender(this.toInternetAddress(address, personal));
    }

    @Nonnull
    protected InternetAddress toInternetAddress(@Nonnull String address, @Nullable String personal) {
        try {
            return personal != null ? new InternetAddress(address, personal) : new InternetAddress(address, true);
        }
        catch (UnsupportedEncodingException | AddressException e) {
            throw new IllegalArgumentException("Could not parse: " + address, e);
        }
    }

    @Nonnull
    public Mail withSender(@Nonnull String address) {
        return this.withSender(address, null);
    }

    @Nullable
    public InternetAddress getSender() {
        return this._sender;
    }

    public boolean hasSender() {
        return this.getSender() != null;
    }

    @Nonnull
    public Map<Message.RecipientType, List<InternetAddress>> getRecipients() {
        return Collections.unmodifiableMap(this._recipients);
    }

    @Nonnull
    public List<InternetAddress> getRecipients(@Nonnull Message.RecipientType type) {
        List<InternetAddress> addresses = this._recipients.get(type);
        return addresses != null ? Collections.unmodifiableList(addresses) : Collections.emptyList();
    }

    @Nonnull
    public List<InternetAddress> getAllRecipients() {
        ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>();
        for (List<InternetAddress> that : this._recipients.values()) {
            addresses.addAll(that);
        }
        return Collections.unmodifiableList(addresses);
    }

    public boolean hasRecipients() {
        boolean result = false;
        for (List<InternetAddress> that : this._recipients.values()) {
            if (that.isEmpty()) continue;
            result = true;
            break;
        }
        return result;
    }

    @Nonnull
    public List<InternetAddress> getRecipientsTo() {
        return this.getRecipients(Message.RecipientType.TO);
    }

    public boolean hasRecipientsTo() {
        return !this.getRecipientsTo().isEmpty();
    }

    @Nonnull
    public List<InternetAddress> getRecipientsCc() {
        return this.getRecipients(Message.RecipientType.CC);
    }

    public boolean hasRecipientsCc() {
        return !this.getRecipientsCc().isEmpty();
    }

    @Nonnull
    public List<InternetAddress> getRecipientsBcc() {
        return this.getRecipients(Message.RecipientType.BCC);
    }

    public boolean hasRecipientsBcc() {
        return !this.getRecipientsBcc().isEmpty();
    }

    @Nonnull
    public Map<ImmutableMimeType, String> getBody() {
        return Collections.unmodifiableMap(this._body);
    }

    public boolean hasBody() {
        boolean result = false;
        for (String body : this._body.values()) {
            if (StringUtils.isEmpty((CharSequence)body)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Nullable
    public String getBody(@Nonnull ImmutableMimeType mimeType) {
        return this._body.get(mimeType);
    }

    public boolean hasBody(@Nonnull ImmutableMimeType mimeType) {
        return !StringUtils.isEmpty((CharSequence)this.getBody(mimeType));
    }

    @Nullable
    public String getSubject() {
        return this._subject;
    }

    public boolean hasSubject() {
        return !StringUtils.isEmpty((CharSequence)this._subject);
    }

    @Nonnull
    protected Mail thisInstance() {
        return this;
    }
}

