/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.echocat.jomon.resources.FileResource;
import org.echocat.jomon.resources.NameEnabledResource;
import org.echocat.jomon.resources.ResourceType;

@ThreadSafe
public class NameEnabledFileResource
extends FileResource
implements NameEnabledResource {
    private String _name;
    private boolean _nameLoaded;

    public NameEnabledFileResource(@Nonnull File file, @Nonnull byte[] md5, @Nonnull ResourceType type) {
        this(file, md5, type, false);
    }

    public NameEnabledFileResource(@Nonnull File file, @Nonnull byte[] md5, @Nonnull ResourceType type, @Nonnull String name) throws IOException {
        this(file, md5, type, name, false);
    }

    public NameEnabledFileResource(@Nonnull File file, @Nonnull byte[] md5, @Nonnull ResourceType type, boolean generated) {
        super(file, md5, type, generated);
    }

    public NameEnabledFileResource(@Nonnull File file, @Nonnull byte[] md5, @Nonnull ResourceType type, @Nonnull String name, boolean generated) throws IOException {
        this(file, md5, type, generated);
        this.setName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String getName() throws IOException {
        NameEnabledFileResource nameEnabledFileResource = this;
        synchronized (nameEnabledFileResource) {
            if (!this._nameLoaded) {
                block29: {
                    File nameFile = this.getNameFile();
                    if (nameFile.isFile()) {
                        try (FileInputStream is = new FileInputStream(nameFile);
                             InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");){
                            this._name = IOUtils.toString((Reader)reader);
                            break block29;
                        }
                    }
                    this._name = null;
                }
                this._nameLoaded = true;
            }
            return this._name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) throws IOException {
        NameEnabledFileResource nameEnabledFileResource = this;
        synchronized (nameEnabledFileResource) {
            this._name = name;
            this._nameLoaded = true;
            File nameFile = this.getNameFile();
            if (name == null) {
                if (nameFile.exists() && !nameFile.delete()) {
                    throw new IOException("Could not delete the old and not longer needed name file: " + nameFile);
                }
            } else {
                FileUtils.forceMkdir((File)nameFile.getParentFile());
                try (FileOutputStream os = new FileOutputStream(nameFile);
                     OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, "UTF-8");){
                    writer.write(name);
                }
            }
        }
    }

    @Override
    public void release() throws IOException {
        try {
            super.release();
        }
        finally {
            this.getNameFile().delete();
        }
    }

    @Nonnull
    public File getNameFile() {
        return new File(this.getFile().getPath() + ".name");
    }
}

