/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Hex;
import org.echocat.jomon.resources.Resource;
import org.echocat.jomon.runtime.codec.Md5Utils;

public abstract class ResourceSupport
implements Resource {
    private volatile byte[] _md5;
    private volatile Long _size;

    public boolean equals(Object o) {
        try {
            boolean result;
            if (this == o) {
                result = true;
            } else if (o == null || !Resource.class.isInstance(o)) {
                result = false;
            } else {
                Resource that = (Resource)o;
                result = Arrays.equals(this.getMd5(), that.getMd5()) && this.getSize() == this.getSize();
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not check equality.", e);
        }
    }

    public int hashCode() {
        try {
            int result = Arrays.hashCode(this.getMd5());
            result = 37 * result + (int)this.getSize();
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not build hashCode.", e);
        }
    }

    public String toString() {
        String result;
        try {
            result = Hex.encodeHexString((byte[])this.getMd5()) + "_" + this.getSize() + "." + this.getType();
        }
        catch (Exception ignored) {
            result = super.toString();
        }
        return result;
    }

    @Override
    @Nonnull
    public byte[] getMd5() throws IOException {
        if (this._md5 == null) {
            try (InputStream is = this.openInputStream();){
                this._md5 = Md5Utils.md5Of((InputStream)is).asBytes();
            }
        }
        return this._md5;
    }

    @Override
    public long getSize() throws IOException {
        if (this._size == null) {
            try (InputStream is = this.openInputStream();){
                byte[] buffer = new byte[4096];
                int read = is.read(buffer);
                long size = 0L;
                while (read >= 0) {
                    size += (long)read;
                    read = is.read(buffer);
                }
                this._size = size;
            }
        }
        return this._size;
    }

    @Override
    public void touch() throws IOException {
    }

    @Override
    public void release() throws IOException {
    }
}

