/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources.optimizing;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.echocat.jomon.resources.MemoryResourceGenerator;
import org.echocat.jomon.resources.Resource;
import org.echocat.jomon.resources.ResourceType;
import org.echocat.jomon.resources.optimizing.OptimizationContext;
import org.echocat.jomon.resources.optimizing.OptimizationContextUtils;
import org.echocat.jomon.resources.optimizing.ResourcesOptimizer;

public class CombineCssResourcesOptimizer
implements ResourcesOptimizer {
    public static final Pattern IMPORT_PATTERN = Pattern.compile("\\s*@import (?:url\\s*\\((\\s*['\"]?((?:.*?|\\s*?))['\"]?\\s*)\\)|src\\s*=\\s*['\"]((?:.|\\s)*?)['\"])\\s*;", 2);
    public static final OptimizationContext.Feature SKIP_CSS_COMBINATION = OptimizationContextUtils.feature(ResourcesOptimizer.class, "skipCssCombination");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Collection<Resource> optimize(@Nonnull Collection<Resource> inputs, @Nonnull OptimizationContext context) throws Exception {
        ArrayList<Resource> outputs = new ArrayList<Resource>();
        try (MemoryResourceGenerator generator = new MemoryResourceGenerator(ResourceType.css, "/combined/");){
            boolean cssWritten = false;
            for (Resource input : inputs) {
                if (ResourceType.css.equals(input.getType()) && !context.isFeatureEnabled(SKIP_CSS_COMBINATION)) {
                    cssWritten = true;
                    try {
                        InputStream inputStream = input.openInputStream();
                        Throwable throwable = null;
                        try {
                            InputStreamReader reader = new InputStreamReader(inputStream);
                            Throwable throwable2 = null;
                            try {
                                String plainContent = IOUtils.toString((Reader)reader);
                                String content = this.handleImports(plainContent, context);
                                OutputStreamWriter writer = new OutputStreamWriter(generator);
                                Throwable throwable3 = null;
                                try {
                                    writer.write(content);
                                    writer.write("\n");
                                    continue;
                                }
                                catch (Throwable throwable4) {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    if (writer == null) continue;
                                    if (throwable3 != null) {
                                        try {
                                            ((Writer)writer).close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable3.addSuppressed(throwable5);
                                        }
                                        continue;
                                    }
                                    ((Writer)writer).close();
                                    continue;
                                }
                            }
                            catch (Throwable throwable6) {
                                throwable2 = throwable6;
                                throw throwable6;
                            }
                            finally {
                                if (reader == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        ((Reader)reader).close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable2.addSuppressed(throwable7);
                                    }
                                    continue;
                                }
                                ((Reader)reader).close();
                                continue;
                            }
                        }
                        catch (Throwable throwable8) {
                            throwable = throwable8;
                            throw throwable8;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable9) {
                                    throwable.addSuppressed(throwable9);
                                }
                                continue;
                            }
                            inputStream.close();
                            continue;
                        }
                    }
                    finally {
                        input.release();
                        continue;
                    }
                }
                outputs.add(input);
            }
            if (cssWritten) {
                outputs.add(generator.getTemporaryBufferedResource());
            } else {
                generator.drop();
            }
        }
        return outputs;
    }

    @Nonnull
    protected String handleImports(@Nonnull String oldCssBody, @Nonnull OptimizationContext context) throws Exception {
        Matcher matcher = IMPORT_PATTERN.matcher(oldCssBody);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String uri = matcher.group(3) != null ? matcher.group(3) : matcher.group(2);
            String importedBody = this.getBodyOf(uri, context);
            String newReplacement = Matcher.quoteReplacement(importedBody);
            matcher.appendReplacement(sb, newReplacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    private String getBodyOf(@Nonnull String uri, @Nonnull OptimizationContext context) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isSupporting(@Nonnull ResourceType type) {
        return ResourceType.css.equals(type);
    }

    @Override
    @Nonnull
    public Set<ResourceType> getSupportedResourceTypes() {
        return Collections.singleton(ResourceType.css);
    }
}

