/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources.optimizing;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.echocat.jomon.resources.MemoryResourceGenerator;
import org.echocat.jomon.resources.Resource;
import org.echocat.jomon.resources.ResourceType;
import org.echocat.jomon.resources.UriEnabledResource;
import org.echocat.jomon.resources.optimizing.OptimizationContext;
import org.echocat.jomon.resources.optimizing.ResourcePathOptimizer;

public class MakeCssResourcePathAbsoluteOptimizer
implements ResourcePathOptimizer {
    public static final Pattern PATTERN = Pattern.compile("url\\s*\\((\\s*['\"]?((?:.*?|\\s*?))['\"]?\\s*)\\)|src\\s*=\\s*['\"]((?:.|\\s)*?)['\"]", 2);
    public static final Pattern PATH_FIX_PATTERN = Pattern.compile("//+");

    @Override
    @Nonnull
    public Resource optimize(@Nonnull Resource input, @Nonnull OptimizationContext context) throws Exception {
        Resource output;
        block50: {
            if (input instanceof UriEnabledResource && !context.isFeatureEnabled(SKIP_PATH_OPTIMIZATION)) {
                try (InputStream inputStream = input.openInputStream();
                     InputStreamReader reader = new InputStreamReader(inputStream);){
                    String plainContent = IOUtils.toString((Reader)reader);
                    String optimizedBody = this.handleCssBody(plainContent, ((UriEnabledResource)input).getUri(), context);
                    try (MemoryResourceGenerator generator = new MemoryResourceGenerator(input);){
                        try (OutputStreamWriter writer = new OutputStreamWriter(generator);){
                            writer.write(optimizedBody);
                        }
                        output = generator.getTemporaryBufferedResource();
                        break block50;
                    }
                }
            }
            output = input;
        }
        return output;
    }

    @Nonnull
    protected String handleCssBody(@Nonnull String oldCssBody, @Nonnull String uri, @Nonnull OptimizationContext context) throws Exception {
        Matcher matcher = PATTERN.matcher(oldCssBody);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String uriContent;
            String oldMatch = matcher.group();
            String oldUri = matcher.group(3) != null ? matcher.group(3) : matcher.group(2);
            String string = uriContent = matcher.group(1) != null ? matcher.group(1) : oldUri;
            String newUri = this.newUri(uri, oldUri, context);
            if (newUri == null || oldUri.equals(newUri)) continue;
            String newReplacement = Matcher.quoteReplacement(oldMatch.replace(uriContent, newUri));
            matcher.appendReplacement(sb, newReplacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    @Nonnull
    protected String newUri(@Nonnull String cssUri, @Nonnull String resourceUri, @Nonnull OptimizationContext context) throws Exception {
        String result;
        try {
            new URL(resourceUri);
            result = resourceUri;
        }
        catch (MalformedURLException ignored) {
            if (resourceUri.startsWith("/")) {
                result = resourceUri;
            } else {
                String plainTargetUri = cssUri + "/../" + resourceUri;
                String targetUri = PATH_FIX_PATTERN.matcher(plainTargetUri).replaceAll("/");
                result = FilenameUtils.normalizeNoEndSeparator((String)targetUri, (boolean)true);
                if (result == null) {
                    throw new IllegalArgumentException("In " + cssUri + " was an invalid uri for an resource provided: " + resourceUri);
                }
            }
            result = this.toOptimizedUri(cssUri, result, context);
        }
        return result;
    }

    private String toOptimizedUri(@Nonnull String cssUri, @Nonnull String uri, @Nonnull OptimizationContext context) throws Exception {
        String uriSuffix;
        String uriPrefix;
        int indexToTrimAfter = uri.indexOf(63);
        if (indexToTrimAfter < 0) {
            indexToTrimAfter = uri.indexOf(35);
        }
        if (indexToTrimAfter > 0 && indexToTrimAfter + 1 < uri.length()) {
            uriPrefix = uri.substring(0, indexToTrimAfter);
            uriSuffix = uri.substring(indexToTrimAfter);
        } else {
            uriPrefix = uri;
            uriSuffix = "";
        }
        String optimizedPrefix = context.findOptimizeAndReturnUriFor(uriPrefix);
        if (optimizedPrefix == null) {
            throw new IllegalArgumentException("Could not find any resource named '" + uri + "' defined in " + cssUri + ".");
        }
        return optimizedPrefix + uriSuffix;
    }

    @Override
    public boolean isSupporting(@Nonnull ResourceType type) {
        return ResourceType.css.equals(type);
    }

    @Override
    @Nonnull
    public Set<ResourceType> getSupportedResourceTypes() {
        return Collections.singleton(ResourceType.css);
    }
}

