/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.service;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.ServiceTemporaryUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class ServicesManager<I, O>
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ServicesManager.class);
    public static final Duration DEFAULT_CHECK_INTERVAL = new Duration("10s");
    private final Thread _checkThread;
    private volatile Collection<I> _inputs;
    private volatile Duration _checkInterval = DEFAULT_CHECK_INTERVAL;

    protected ServicesManager() {
        this._checkThread = new Thread((Runnable)new Checker(), this.toString() + ".Checker");
        this._checkThread.setDaemon(true);
        this._checkThread.start();
    }

    protected ServicesManager(Duration checkInterval) {
        this();
        this.setCheckInterval(checkInterval);
    }

    public Collection<I> getInputs() {
        return this._inputs;
    }

    public void setInputs(Collection<I> inputs) {
        this._inputs = inputs;
    }

    @Nonnull
    public Duration getCheckInterval() {
        return this._checkInterval;
    }

    public void setCheckInterval(@Nonnull Duration checkInterval) {
        this._checkInterval = checkInterval;
    }

    protected void setCheckerThreadName(@Nonnull String threadName) {
        this._checkThread.setName(threadName);
    }

    public void check() throws Exception, InterruptedException {
        Collection<I> inputs = this._inputs;
        this.check(inputs != null ? inputs : Collections.emptySet());
    }

    @Nullable
    protected abstract void check(@Nonnull Collection<I> var1) throws Exception;

    @Nullable
    protected abstract O tryTake();

    public abstract void markAsGone(@Nonnull O var1) throws InterruptedException;

    @Nonnull
    public O take() throws InterruptedException {
        O output = this.tryTake();
        if (output == null) {
            try {
                this.check();
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not take next connection.", e);
            }
            output = this.tryTake();
        }
        if (output == null) {
            throw new ServiceTemporaryUnavailableException("There is no services available. Are all services gone?");
        }
        return output;
    }

    @Override
    public void close() {
        if (this._checkThread.isAlive()) {
            do {
                this._checkThread.interrupt();
                try {
                    this._checkThread.join(10L);
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                    LOG.warn("Try to wait for the end of checkThread but got interrupt signal. Ignoring this for now. We hope that this thread will go to the end by his own. If not we have a zombie thread in the JVM.");
                }
            } while (!Thread.currentThread().isInterrupted() && this._checkThread.isAlive());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected class Checker
    implements Runnable {
        protected Checker() {
        }

        @Override
        public void run() {
            long lastError = 0L;
            while (!Thread.currentThread().isInterrupted()) {
                if (!Thread.currentThread().isInterrupted()) {
                    try {
                        Thread.sleep(ServicesManager.this._checkInterval.in(TimeUnit.MILLISECONDS));
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                    }
                }
                try {
                    ServicesManager.this.check();
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    long now = System.currentTimeMillis();
                    if (lastError + TimeUnit.MINUTES.toMillis(10L) >= now) continue;
                    LOG.error("While the check of the service inputs we got an error. This could be temporary but normally this is an serious error. The application tries to continue working with the old service inputs but it could be that this inputs are out of date. You will see this message max. every 10 minutes.", (Throwable)e);
                    lastError = now;
                }
            }
        }
    }
}

