/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.testing.environments;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.generation.Requirement;
import org.echocat.jomon.runtime.logging.Log4J2BasedLoggingEnvironmentConfiguration;
import org.echocat.jomon.runtime.logging.Log4JBasedLoggingEnvironmentConfiguration;
import org.echocat.jomon.runtime.logging.LogbackBasedLoggingEnvironmentConfiguration;
import org.echocat.jomon.runtime.logging.LoggingEnvironmentConfiguration;
import org.echocat.jomon.runtime.logging.LoggingEnvironmentGenerators;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.echocat.jomon.testing.environments.BaseEnvironment;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;

public class LoggingEnvironment
extends BaseEnvironment
implements TestRule,
org.echocat.jomon.runtime.logging.LoggingEnvironment {
    public static final Type DEFAULT_TYPE = Type.valueOf(System.getProperty(LoggingEnvironment.class.getName() + ".type", Type.logback.name()));
    @Nullable
    private final Class<?> _reference;
    @Nonnull
    private final LoggingEnvironmentConfiguration _configuration;
    @Nullable
    private org.echocat.jomon.runtime.logging.LoggingEnvironment _delegate;

    public LoggingEnvironment(@Nonnull LoggingEnvironmentConfiguration configuration) {
        this._reference = null;
        this._configuration = configuration;
    }

    public LoggingEnvironment() {
        this((Class)null);
    }

    public LoggingEnvironment(@Nullable Type type) {
        this(null, type);
    }

    public LoggingEnvironment(@Nonnull Object object) {
        this(object, null);
    }

    public LoggingEnvironment(@Nonnull Object object, @Nullable Type type) {
        this(object instanceof Class ? (Class<?>)object : object.getClass(), type);
    }

    public LoggingEnvironment(@Nullable Class<?> clazz) {
        this(clazz, null);
    }

    public LoggingEnvironment(@Nullable Class<?> clazz, @Nullable Type type) {
        Class<?> targetClass = clazz != null ? clazz : this.findTopFromCallStack();
        this._reference = targetClass;
        this._configuration = this.configurationFor(targetClass, type);
    }

    @Nonnull
    protected LoggingEnvironmentConfiguration configurationFor(@Nonnull Class<?> clazz, @Nullable Type type) {
        LoggingEnvironmentConfiguration result;
        Type targetType;
        Type type2 = targetType = type != null ? type : DEFAULT_TYPE;
        if (targetType == Type.log4j) {
            result = this.log4jConfigurationFor(clazz);
        } else if (targetType == Type.log4j2) {
            result = this.log4J2ConfigurationFor(clazz);
        } else if (targetType == Type.logback) {
            result = this.logbackConfigurationFor(clazz);
        } else {
            throw new IllegalArgumentException("Could not handle type: " + (Object)((Object)targetType));
        }
        return result;
    }

    @Nonnull
    protected LoggingEnvironmentConfiguration log4jConfigurationFor(@Nonnull Class<?> clazz) {
        String configurationFile = this.configurationFileFor(clazz, ".log4j.xml", "log4j.xml", "org/echocat/jomon/runtime/logging/default.log4j.xml");
        return Log4JBasedLoggingEnvironmentConfiguration.ForClassLoader.log4JBasedLoggingFor((ClassLoader)clazz.getClassLoader(), (String)configurationFile);
    }

    @Nonnull
    protected LoggingEnvironmentConfiguration log4J2ConfigurationFor(@Nonnull Class<?> clazz) {
        String configurationFile = this.configurationFileFor(clazz, ".log4j2.xml", "log4j2.xml", "org/echocat/jomon/runtime/logging/default.log4j2.xml");
        return Log4J2BasedLoggingEnvironmentConfiguration.ForClassLoader.log4J2BasedLoggingFor((ClassLoader)clazz.getClassLoader(), (String)configurationFile);
    }

    @Nonnull
    protected LoggingEnvironmentConfiguration logbackConfigurationFor(@Nonnull Class<?> clazz) {
        String configurationFile = this.configurationFileFor(clazz, ".logback.xml", "logback.xml", "org/echocat/jomon/runtime/logging/default.logback.xml");
        return LogbackBasedLoggingEnvironmentConfiguration.ForClassLoader.logbackBasedLoggingFor((ClassLoader)clazz.getClassLoader(), (String)configurationFile);
    }

    @Nonnull
    protected String configurationFileFor(@Nonnull Class<?> clazz, @Nonnull String fileNameSuffixOfClasses, @Nonnull String fileNameInPackage, @Nonnull String defaultConfigurationFile) {
        String configuration = this.findFileFor(clazz, fileNameSuffixOfClasses, fileNameInPackage);
        if (configuration == null) {
            configuration = this.findFileFor(LoggingEnvironment.class, fileNameSuffixOfClasses, fileNameInPackage);
        }
        if (configuration == null) {
            configuration = defaultConfigurationFile;
        }
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        LoggingEnvironment loggingEnvironment = this;
        synchronized (loggingEnvironment) {
            if (this._delegate == null) {
                this._delegate = (org.echocat.jomon.runtime.logging.LoggingEnvironment)LoggingEnvironmentGenerators.loggingEnvironmentGenerator().generate((Requirement)this._configuration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LoggingEnvironment loggingEnvironment = this;
        synchronized (loggingEnvironment) {
            try {
                ResourceUtils.closeQuietly((AutoCloseable)this._delegate);
            }
            finally {
                this._delegate = null;
            }
        }
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                LoggingEnvironment.this.init();
                try {
                    base.evaluate();
                }
                finally {
                    ResourceUtils.closeQuietly((AutoCloseable)LoggingEnvironment.this);
                }
            }
        };
    }

    @Nonnull
    public Logger getLogger(@Nonnull String name) {
        return this._delegate.getLogger(name);
    }

    @Nonnull
    public Logger getLogger(@Nonnull Class<?> reference) {
        return this._delegate.getLogger(reference);
    }

    @Nullable
    @Deprecated
    protected Class<?> getReference() {
        return this._reference;
    }

    public static enum Type {
        log4j,
        log4j2,
        logback;

    }
}

