/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class BeanPostConfigurer
implements BeanFactoryPostProcessor,
PriorityOrdered {
    @Nullable
    private Properties _properties;
    @Nonnull
    private Charset _charset = Charset.forName("UTF-8");
    @Nullable
    private Properties _setProperties;
    @Nullable
    private Resource _propertiesFile;
    @Nullable
    private Properties _setBySystemProperties;
    @Nullable
    private Properties _setByResource;

    public BeanPostConfigurer() throws Exception {
        this._properties = this.createNewProperties();
    }

    @Nonnull
    protected Properties createNewProperties() throws Exception {
        Object key;
        Properties result = new Properties();
        if (this._setProperties != null) {
            for (Map.Entry<Object, Object> entry : this._setProperties.entrySet()) {
                key = entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null) continue;
                result.put(key, value);
            }
        }
        if (this._propertiesFile != null && this._propertiesFile.exists()) {
            this._setByResource = new Properties();
            Throwable throwable = null;
            try (InputStream is = this._propertiesFile.getInputStream();
                 InputStreamReader reader22 = new InputStreamReader(is, this._charset);){
                result.load(reader22);
                this._setByResource.putAll((Map<?, ?>)result);
            }
            catch (Throwable reader22) {
                Throwable throwable2 = reader22;
                throw reader22;
            }
        }
        this._setBySystemProperties = new Properties();
        for (Map.Entry<Object, Object> entry : ((Map)System.getProperties()).entrySet()) {
            key = (String)entry.getKey();
            if (!((String)key).contains("#") && !((String)key).contains("@")) continue;
            result.put(key, entry.getValue());
            this._setBySystemProperties.setProperty((String)key, (String)entry.getValue());
        }
        return result;
    }

    public void setPropertiesFrom(Resource propertiesFile) throws Exception {
        this._propertiesFile = propertiesFile;
        this._properties = this.createNewProperties();
    }

    public void setPropertiesFromFileIfExists(File propertiesFile) throws Exception {
        this._propertiesFile = propertiesFile != null ? new FileSystemResource(propertiesFile) : null;
        this._properties = this.createNewProperties();
    }

    public void setProperties(Properties properties) throws Exception {
        this._setProperties = properties;
        this._properties = this.createNewProperties();
    }

    @Nullable
    public Properties getSetBySystemProperties() {
        return this._setBySystemProperties;
    }

    @Nullable
    public Properties getSetByResource() {
        return this._setByResource;
    }

    public void setCharset(Charset charset) throws Exception {
        this._charset = charset != null ? charset : Charset.forName("UTF-8");
        this._properties = this.createNewProperties();
    }

    public void postProcessBeanFactory(@Nonnull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        for (Map.Entry keyAndValue : ((Map)this._properties).entrySet()) {
            this.handleProperty((String)keyAndValue.getKey(), (String)keyAndValue.getValue(), beanFactory);
        }
    }

    protected void handleProperty(@Nonnull String key, @Nullable String value, @Nonnull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        BeanAndPropertyName beanAndPropertyName = this.getBeanAndPropertyNameOf(key);
        for (AbstractBeanDefinition beanDefinition : this.getAllBeanDefinitionsBy(beanAndPropertyName.getBeanName(), beanFactory)) {
            this.handleProperty(beanAndPropertyName, beanDefinition, value, beanAndPropertyName.getPropertyValueType(), beanFactory);
        }
    }

    @Nonnull
    protected List<AbstractBeanDefinition> getAllBeanDefinitionsBy(@Nonnull String targetBeanDefinitionName, @Nonnull ConfigurableListableBeanFactory beanFactory) {
        ArrayList<AbstractBeanDefinition> result = new ArrayList<AbstractBeanDefinition>();
        for (String beanDefinitionName : beanFactory.getBeanDefinitionNames()) {
            if (targetBeanDefinitionName.equals(beanDefinitionName) || beanDefinitionName.startsWith(targetBeanDefinitionName + "#")) {
                result.add((AbstractBeanDefinition)beanFactory.getBeanDefinition(beanDefinitionName));
                continue;
            }
            for (String alias : beanFactory.getAliases(beanDefinitionName)) {
                if (!targetBeanDefinitionName.equals(alias)) continue;
                result.add((AbstractBeanDefinition)beanFactory.getBeanDefinition(beanDefinitionName));
            }
        }
        return result;
    }

    protected void handleProperty(@Nonnull BeanAndPropertyName beanAndPropertyName, @Nonnull AbstractBeanDefinition beanDefinition, @Nullable String value, @Nonnull PropertyValueType propertyValueType, @Nonnull ConfigurableListableBeanFactory beanFactory) {
        MutablePropertyValues propertyValues = this.getPropertyValues(beanDefinition);
        if (propertyValueType != PropertyValueType.reference || beanFactory.containsBean(value)) {
            this.removeOldPropertyIfNeeded(beanAndPropertyName, propertyValues);
            PropertyValue propertyValue = new PropertyValue(beanAndPropertyName.getPropertyName(), propertyValueType == PropertyValueType.reference ? new RuntimeBeanReference(value) : value);
            propertyValues.addPropertyValue(propertyValue);
        }
    }

    @Nonnull
    protected MutablePropertyValues getPropertyValues(@Nonnull AbstractBeanDefinition beanDefinition) {
        MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
        if (propertyValues == null) {
            propertyValues = new MutablePropertyValues();
            beanDefinition.setPropertyValues(propertyValues);
        }
        return propertyValues;
    }

    protected void removeOldPropertyIfNeeded(@Nonnull BeanAndPropertyName beanAndPropertyName, @Nonnull MutablePropertyValues propertyValues) {
        PropertyValue propertyValue = propertyValues.getPropertyValue(beanAndPropertyName.getPropertyName());
        if (propertyValue != null) {
            propertyValues.removePropertyValue(propertyValue);
        }
    }

    @Nullable
    protected BeanAndPropertyName getBeanAndPropertyNameOf(@Nonnull String key) throws BeansException {
        String[] parts = key.split("[#|@]");
        if (parts.length != 2) {
            throw new FatalBeanException("The property key '" + key + "' is invalid. The syntax is: <beanName>#<propertyName>");
        }
        PropertyValueType propertyValueType = key.contains("#") ? PropertyValueType.value : PropertyValueType.reference;
        return new BeanAndPropertyName(parts[0], parts[1], propertyValueType);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    protected class BeanAndPropertyName {
        private final String _beanName;
        private final String _propertyName;
        private final PropertyValueType _propertyValueType;

        protected BeanAndPropertyName(@Nonnull String beanName, @Nonnull String propertyName, PropertyValueType propertyValueType) {
            this._beanName = beanName;
            this._propertyName = propertyName;
            this._propertyValueType = propertyValueType;
        }

        @Nonnull
        protected String getBeanName() {
            return this._beanName;
        }

        @Nonnull
        protected String getPropertyName() {
            return this._propertyName;
        }

        @Nonnull
        public PropertyValueType getPropertyValueType() {
            return this._propertyValueType;
        }
    }

    protected static enum PropertyValueType {
        value,
        reference;

    }
}

