/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.io.UrlUtils;
import org.echocat.jomon.spring.application.Application;
import org.echocat.jomon.spring.application.ApplicationGenerators;
import org.echocat.jomon.spring.application.ApplicationRequirement;
import org.echocat.jomon.spring.application.DefaultApplicationRequirement;
import org.springframework.context.ConfigurableApplicationContext;

public class Boot {
    @Nullable
    private static Application c_application;

    public static void main(String[] args) {
        if (args == null || args.length != 1 && args.length != 2) {
            System.err.println("java -cp <?> " + Boot.class.getName() + " <boot bean.xml or configuration class name in classpath> [log4j configuration in classpath]");
            System.exit(1);
        } else {
            DefaultApplicationRequirement requirement = DefaultApplicationRequirement.xmlConfiguredApplicationFor(Boot.class.getClassLoader(), args[0]);
            if (args.length > 1) {
                requirement.withLog4jFor(Boot.class.getClassLoader(), args[1]);
            }
            Boot.start(requirement);
        }
    }

    @Nonnull
    public static Application start(@Nonnull ApplicationRequirement requirement) {
        return Boot.startApplication(requirement);
    }

    @Nonnull
    public static Application startApplication(@Nonnull ApplicationRequirement requirement) {
        Application application;
        c_application = application = (Application)ApplicationGenerators.applicationGenerator().generate(requirement);
        return application;
    }

    @Deprecated
    @Nonnull
    public static String getApplicationName() {
        Application application = c_application;
        String result = application != null ? application.getInformation().getTitle() : Boot.class.getName();
        return result;
    }

    @Deprecated
    @Nonnull
    public static ConfigurableApplicationContext start(@Nonnull Class<?> reference, @Nonnull String bootBeanXmlFileName) {
        return (ConfigurableApplicationContext)Boot.start(DefaultApplicationRequirement.xmlConfiguredApplicationFor(reference, bootBeanXmlFileName)).getApplicationContext();
    }

    @Deprecated
    @Nonnull
    public static ConfigurableApplicationContext start(@Nonnull Class<?> reference, @Nonnull String bootBeanXmlFileName, @Nullable String log4jConfigurationFileName) {
        return (ConfigurableApplicationContext)Boot.start(DefaultApplicationRequirement.xmlConfiguredApplicationFor(reference, bootBeanXmlFileName).withLog4jFor(reference, log4jConfigurationFileName)).getApplicationContext();
    }

    @Deprecated
    @Nonnull
    public static ConfigurableApplicationContext start(@Nonnull String bootBeanXmlInClassPath) {
        return (ConfigurableApplicationContext)Boot.start(DefaultApplicationRequirement.xmlConfiguredApplicationFor(Boot.class.getClassLoader(), bootBeanXmlInClassPath)).getApplicationContext();
    }

    @Deprecated
    @Nonnull
    public static ConfigurableApplicationContext start(@Nonnull String bootBeanXmlInClassPath, @Nullable String log4jConfigurationInClassPath) {
        return (ConfigurableApplicationContext)Boot.start(DefaultApplicationRequirement.xmlConfiguredApplicationFor(Boot.class.getClassLoader(), bootBeanXmlInClassPath).withLog4jFor(Boot.class.getClassLoader(), log4jConfigurationInClassPath)).getApplicationContext();
    }

    @Deprecated
    @Nonnull
    public static ConfigurableApplicationContext startComponent(@Nonnull String bootBeanXmlInClassPath, @Nonnull String applicationName) {
        return (ConfigurableApplicationContext)Boot.start(DefaultApplicationRequirement.xmlConfiguredApplicationFor(Boot.class.getClassLoader(), bootBeanXmlInClassPath).withApplicationTitle(applicationName)).getApplicationContext();
    }

    private Boot() {
    }

    static {
        UrlUtils.registerUrlStreamHandlerIfNeeded();
    }
}

