/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring.application;

import java.util.Collection;
import javax.annotation.Nonnull;
import org.echocat.jomon.spring.application.ApplicationContextGenerator;
import org.echocat.jomon.spring.application.ApplicationContextRequirement;
import org.echocat.jomon.spring.application.XmlBasedApplicationContextRequirement;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.Resource;

public class XmlBasedApplicationContextGenerator
implements ApplicationContextGenerator {
    @Override
    public boolean supports(@Nonnull ApplicationContextRequirement configuration) {
        return configuration instanceof XmlBasedApplicationContextRequirement;
    }

    @Nonnull
    public ConfigurableApplicationContext generate(@Nonnull ApplicationContextRequirement configuration) {
        if (configuration instanceof XmlBasedApplicationContextRequirement) {
            return this.generate((XmlBasedApplicationContextRequirement)configuration);
        }
        throw new IllegalArgumentException("Could not handle " + configuration + ".");
    }

    @Nonnull
    protected ConfigurableApplicationContext generate(@Nonnull XmlBasedApplicationContextRequirement configuration) {
        ApplicationContextImpl result = new ApplicationContextImpl(configuration.getConfigurationFiles());
        result.setParent(configuration.getParentApplicationContext());
        result.setClassLoader(configuration.getClassLoader());
        return result;
    }

    protected static class ApplicationContextImpl
    extends AbstractXmlApplicationContext {
        @Nonnull
        private final Resource[] _configurations;

        public ApplicationContextImpl(@Nonnull Collection<Resource> configuration) {
            this._configurations = configuration.toArray(new Resource[configuration.size()]);
        }

        protected Resource[] getConfigResources() {
            return this._configurations;
        }
    }
}

