/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class HostService {
    private final InetSocketAddress _address;
    private final int _priority;
    private final int _weight;
    private final long _ttl;

    @Nonnull
    public static HostService hostService(@Nonnull InetAddress address, @Nonnegative int port, @Nonnegative int priority, @Nonnegative int weight, @Nonnegative long ttl) {
        return HostService.hostService(new InetSocketAddress(address, port), priority, weight, ttl);
    }

    @Nonnull
    public static HostService hostService(@Nonnull InetSocketAddress address, @Nonnegative int priority, @Nonnegative int weight, @Nonnegative long ttl) {
        return new HostService(address, priority, weight, ttl);
    }

    public HostService(@Nonnull InetSocketAddress address, @Nonnegative int priority, @Nonnegative int weight, @Nonnegative long ttl) {
        this._priority = priority;
        this._weight = weight;
        this._address = address;
        this._ttl = ttl;
    }

    @Nonnull
    public InetSocketAddress getAddress() {
        return this._address;
    }

    @Nonnegative
    public int getPriority() {
        return this._priority;
    }

    @Nonnegative
    public int getWeight() {
        return this._weight;
    }

    @Nonnegative
    public long getTtl() {
        return this._ttl;
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof HostService)) {
            result = false;
        } else {
            HostService that = (HostService)o;
            result = this._address.equals(that._address);
        }
        return result;
    }

    public int hashCode() {
        return this._address.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._address).append("{ttl=").append(this._ttl).append(", priority=").append(this._priority).append(", weight=").append(this._weight).append("}");
        return sb.toString();
    }
}

