/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.net.NetworkInterfaceQuery;
import org.echocat.jomon.net.NetworkInterfaceRepository;
import org.echocat.jomon.net.NetworkInterfaceType;

public class NetworkInterfaceUtils {
    @Nonnull
    private static final NetworkInterfaceQuery LOOP_BACK_QUERY = NetworkInterfaceQuery.networkInterface().whichIsOfType(NetworkInterfaceType.loopBack);

    @Nonnull
    public static NetworkInterface getLoopBackInterface() {
        NetworkInterface networkInterface = NetworkInterfaceRepository.networkInterfaceRepository().findOneBy(LOOP_BACK_QUERY);
        if (networkInterface == null) {
            throw new IllegalStateException("Could not find a loopBack device.");
        }
        return networkInterface;
    }

    @Nullable
    public static InetAddress findFirstAddressOf(@Nonnull NetworkInterface networkInterface) {
        Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
        return addresses.hasMoreElements() ? addresses.nextElement() : null;
    }

    @Nonnull
    public static InetAddress getFirstAddressOf(@Nonnull NetworkInterface networkInterface) {
        InetAddress address = NetworkInterfaceUtils.findFirstAddressOf(networkInterface);
        if (address == null) {
            throw new IllegalArgumentException("Interface " + networkInterface.getName() + " has no address.");
        }
        return address;
    }

    public static boolean containsAddress(@Nonnull NetworkInterface networkInterface, @Nonnull InetAddress address) {
        boolean result = false;
        Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress current = addresses.nextElement();
            if (!current.equals(address)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static void assertThatContainsAddress(@Nonnull NetworkInterface networkInterface, @Nonnull InetAddress address) throws IllegalArgumentException {
        if (!NetworkInterfaceUtils.containsAddress(networkInterface, address)) {
            throw new IllegalArgumentException("Interface " + networkInterface.getName() + " is not bound to address " + address + ".");
        }
    }

    private NetworkInterfaceUtils() {
    }
}

