/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.dns;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.StringReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.Header;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.Type;
import org.xbill.DNS.Zone;
import org.xbill.DNS.ZoneTransferException;

public class DnsServer
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DnsServer.class);
    private volatile boolean _closed;
    private final Set<Thread> _threads = new HashSet<Thread>();
    private final Set<Closeable> _closeables = new HashSet<Closeable>();
    static final int FLAG_DNSSECOK = 1;
    static final int FLAG_SIGONLY = 2;
    private final Map<Integer, Cache> _caches;
    private final Map<Name, Zone> _znames;
    private final Map<Name, TSIG> _tsigs;

    private static String addrport(InetAddress addr, int port) {
        return addr.getHostAddress() + "#" + port;
    }

    public DnsServer() {
        this(null);
    }

    public DnsServer(@Nullable String config) {
        BufferedReader reader = new BufferedReader(new StringReader(config));
        this._caches = new HashMap<Integer, Cache>();
        this._znames = new HashMap<Name, Zone>();
        this._tsigs = new HashMap<Name, TSIG>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                if (!st.hasMoreTokens()) continue;
                String keyword = st.nextToken();
                if (!st.hasMoreTokens()) {
                    throw new IllegalArgumentException("Invalid line: " + line);
                }
                if (keyword.charAt(0) == '#') continue;
                if (keyword.equals("primary")) {
                    this.addPrimaryZone(st.nextToken(), st.nextToken());
                    continue;
                }
                if (keyword.equals("secondary")) {
                    this.addSecondaryZone(st.nextToken(), st.nextToken());
                    continue;
                }
                if (keyword.equals("cache")) {
                    Cache cache = new Cache(st.nextToken());
                    this._caches.put(1, cache);
                    continue;
                }
                if (keyword.equals("key")) {
                    String s1 = st.nextToken();
                    String s2 = st.nextToken();
                    if (st.hasMoreTokens()) {
                        this.addTSIG(s1, s2, st.nextToken());
                        continue;
                    }
                    this.addTSIG("hmac-md5", s1, s2);
                    continue;
                }
                throw new IllegalArgumentException("unknown keyword: " + keyword);
            }
        }
        catch (IOException | ZoneTransferException e) {
            throw new RuntimeException("Could not create server.", e);
        }
        LOG.info("jnamed: running");
    }

    public void addPrimaryZone(String zname, String zonefile) throws IOException {
        Name origin = null;
        if (zname != null) {
            origin = Name.fromString((String)zname, (Name)Name.root);
        }
        Zone newzone = new Zone(origin, zonefile);
        this.addPrimaryZone(newzone);
    }

    public void addPrimaryZone(@Nonnull Zone zone) throws IOException {
        this._znames.put(zone.getOrigin(), zone);
    }

    public void addSecondaryZone(String zone, String remote) throws IOException, ZoneTransferException {
        Name zname = Name.fromString((String)zone, (Name)Name.root);
        Zone newzone = new Zone(zname, 1, remote);
        this._znames.put(zname, newzone);
    }

    public void addSecondaryZone(@Nonnull Zone zone) {
        this._znames.put(zone.getOrigin(), zone);
    }

    public void addTSIG(String algstr, String namestr, String key) throws IOException {
        Name name = Name.fromString((String)namestr, (Name)Name.root);
        this._tsigs.put(name, new TSIG(algstr, namestr, key));
    }

    public Cache getCache(int dclass) {
        Cache c = this._caches.get(dclass);
        if (c == null) {
            c = new Cache(dclass);
            this._caches.put(dclass, c);
        }
        return c;
    }

    public Zone findBestZone(Name name) {
        Zone foundzone = this._znames.get(name);
        if (foundzone != null) {
            return foundzone;
        }
        int labels = name.labels();
        for (int i = 1; i < labels; ++i) {
            Name tname = new Name(name, i);
            foundzone = this._znames.get(tname);
            if (foundzone == null) continue;
            return foundzone;
        }
        return null;
    }

    public RRset findExactMatch(Name name, int type, int dclass, boolean glue) {
        Zone zone = this.findBestZone(name);
        if (zone != null) {
            return zone.findExactMatch(name, type);
        }
        Cache cache = this.getCache(dclass);
        RRset[] rrsets = glue ? cache.findAnyRecords(name, type) : cache.findRecords(name, type);
        if (rrsets == null) {
            return null;
        }
        return rrsets[0];
    }

    void addRRset(Name name, Message response, RRset rrset, int section, int flags) {
        Record r;
        for (int s = 1; s <= section; ++s) {
            if (!response.findRRset(name, rrset.getType(), s)) continue;
            return;
        }
        if ((flags & 2) == 0) {
            Iterator it = rrset.rrs();
            while (it.hasNext()) {
                r = (Record)it.next();
                if (r.getName().isWild() && !name.isWild()) {
                    r = r.withName(name);
                }
                response.addRecord(r, section);
            }
        }
        if ((flags & 3) != 0) {
            Iterator it = rrset.sigs();
            while (it.hasNext()) {
                r = (Record)it.next();
                if (r.getName().isWild() && !name.isWild()) {
                    r = r.withName(name);
                }
                response.addRecord(r, section);
            }
        }
    }

    private void addSOA(Message response, Zone zone) {
        response.addRecord((Record)zone.getSOA(), 2);
    }

    private void addNS(Message response, Zone zone, int flags) {
        RRset nsRecords = zone.getNS();
        this.addRRset(nsRecords.getName(), response, nsRecords, 2, flags);
    }

    private void addCacheNS(Message response, Cache cache, Name name) {
        SetResponse sr = cache.lookupRecords(name, 2, 0);
        if (!sr.isDelegation()) {
            return;
        }
        RRset nsRecords = sr.getNS();
        Iterator it = nsRecords.rrs();
        while (it.hasNext()) {
            Record r = (Record)it.next();
            response.addRecord(r, 2);
        }
    }

    private void addGlue(Message response, Name name, int flags) {
        RRset a = this.findExactMatch(name, 1, 1, true);
        if (a == null) {
            return;
        }
        this.addRRset(name, response, a, 3, flags);
    }

    private void addAdditional2(Message response, int section, int flags) {
        Record[] records = response.getSectionArray(section);
        for (int i = 0; i < records.length; ++i) {
            Record r = records[i];
            Name glueName = r.getAdditionalName();
            if (glueName == null) continue;
            this.addGlue(response, glueName, flags);
        }
    }

    private void addAdditional(Message response, int flags) {
        this.addAdditional2(response, 1, flags);
        this.addAdditional2(response, 2, flags);
    }

    byte addAnswer(Message response, Name name, int type, int dclass, int iterations, int flags) {
        SetResponse sr;
        Zone zone;
        int rcode = 0;
        if (iterations > 6) {
            return 0;
        }
        if (type == 24 || type == 46) {
            type = 255;
            flags |= 2;
        }
        if ((zone = this.findBestZone(name)) != null) {
            sr = zone.findRecords(name, type);
        } else {
            Cache cache = this.getCache(dclass);
            sr = cache.lookupRecords(name, type, 3);
        }
        if (sr.isUnknown()) {
            this.addCacheNS(response, this.getCache(dclass), name);
        }
        if (sr.isNXDOMAIN()) {
            response.getHeader().setRcode(3);
            if (zone != null) {
                this.addSOA(response, zone);
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
            }
            rcode = 3;
        } else if (sr.isNXRRSET()) {
            if (zone != null) {
                this.addSOA(response, zone);
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
            }
        } else if (sr.isDelegation()) {
            RRset nsRecords = sr.getNS();
            this.addRRset(nsRecords.getName(), response, nsRecords, 2, flags);
        } else if (sr.isCNAME()) {
            CNAMERecord cname = sr.getCNAME();
            RRset rrset = new RRset((Record)cname);
            this.addRRset(name, response, rrset, 1, flags);
            if (zone != null && iterations == 0) {
                response.getHeader().setFlag(5);
            }
            rcode = this.addAnswer(response, cname.getTarget(), type, dclass, iterations + 1, flags);
        } else if (sr.isDNAME()) {
            Name newname;
            DNAMERecord dname = sr.getDNAME();
            RRset rrset = new RRset((Record)dname);
            this.addRRset(name, response, rrset, 1, flags);
            try {
                newname = name.fromDNAME(dname);
            }
            catch (NameTooLongException ignored) {
                return 6;
            }
            rrset = new RRset((Record)new CNAMERecord(name, dclass, 0L, newname));
            this.addRRset(name, response, rrset, 1, flags);
            if (zone != null && iterations == 0) {
                response.getHeader().setFlag(5);
            }
            rcode = this.addAnswer(response, newname, type, dclass, iterations + 1, flags);
        } else if (sr.isSuccessful()) {
            RRset[] rrsets = sr.answers();
            for (int i = 0; i < rrsets.length; ++i) {
                this.addRRset(name, response, rrsets[i], 1, flags);
            }
            if (zone != null) {
                this.addNS(response, zone, flags);
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
            } else {
                this.addCacheNS(response, this.getCache(dclass), name);
            }
        }
        return (byte)rcode;
    }

    byte[] doAXFR(Name name, Message query, TSIG tsig, TSIGRecord qtsig, Socket s) {
        Zone zone = this._znames.get(name);
        boolean first = true;
        if (zone == null) {
            return this.errorMessage(query, 5);
        }
        Iterator it = zone.AXFR();
        try {
            DataOutputStream dataOut = new DataOutputStream(s.getOutputStream());
            int id = query.getHeader().getID();
            while (it.hasNext()) {
                RRset rrset = (RRset)it.next();
                Message response = new Message(id);
                Header header = response.getHeader();
                header.setFlag(0);
                header.setFlag(5);
                this.addRRset(rrset.getName(), response, rrset, 1, 1);
                if (tsig != null) {
                    tsig.applyStream(response, qtsig, first);
                    qtsig = response.getTSIG();
                }
                first = false;
                byte[] out = response.toWire();
                dataOut.writeShort(out.length);
                dataOut.write(out);
            }
        }
        catch (IOException ignored) {
            LOG.info("AXFR failed");
        }
        IOUtils.closeQuietly((Socket)s);
        return null;
    }

    byte[] generateReply(Message query, byte[] in, int length, Socket s) throws IOException {
        int flags = 0;
        Header header = query.getHeader();
        if (header.getFlag(0)) {
            return null;
        }
        if (header.getRcode() != 0) {
            return this.errorMessage(query, 1);
        }
        if (header.getOpcode() != 0) {
            return this.errorMessage(query, 4);
        }
        Record queryRecord = query.getQuestion();
        TSIGRecord queryTSIG = query.getTSIG();
        TSIG tsig = null;
        if (queryTSIG != null && ((tsig = this._tsigs.get(queryTSIG.getName())) == null || tsig.verify(query, in, length, null) != 0)) {
            return this.formerrMessage(in);
        }
        OPTRecord queryOPT = query.getOPT();
        if (queryOPT == null || queryOPT.getVersion() > 0) {
            // empty if block
        }
        int maxLength = s != null ? 65535 : (queryOPT != null ? Math.max(queryOPT.getPayloadSize(), 512) : 512);
        if (queryOPT != null && (queryOPT.getFlags() & 0x8000) != 0) {
            flags = 1;
        }
        Message response = new Message(query.getHeader().getID());
        response.getHeader().setFlag(0);
        if (query.getHeader().getFlag(7)) {
            response.getHeader().setFlag(7);
        }
        response.addRecord(queryRecord, 0);
        Name name = queryRecord.getName();
        int type = queryRecord.getType();
        int dclass = queryRecord.getDClass();
        if (type == 252 && s != null) {
            return this.doAXFR(name, query, tsig, queryTSIG, s);
        }
        if (!Type.isRR((int)type) && type != 255) {
            return this.errorMessage(query, 4);
        }
        byte rcode = this.addAnswer(response, name, type, dclass, 0, flags);
        if (rcode != 0 && rcode != 3) {
            return this.errorMessage(query, rcode);
        }
        this.addAdditional(response, flags);
        if (queryOPT != null) {
            int optflags = flags == 1 ? 32768 : 0;
            OPTRecord opt = new OPTRecord(4096, (int)rcode, 0, optflags);
            response.addRecord((Record)opt, 3);
        }
        response.setTSIG(tsig, 0, queryTSIG);
        return response.toWire(maxLength);
    }

    byte[] buildErrorMessage(Header header, int rcode, Record question) {
        Message response = new Message();
        response.setHeader(header);
        for (int i = 0; i < 4; ++i) {
            response.removeAllRecords(i);
        }
        if (rcode == 2) {
            response.addRecord(question, 0);
        }
        header.setRcode(rcode);
        return response.toWire();
    }

    public byte[] formerrMessage(byte[] in) {
        Header header;
        try {
            header = new Header(in);
        }
        catch (IOException ignored) {
            return null;
        }
        return this.buildErrorMessage(header, 1, null);
    }

    public byte[] errorMessage(Message query, int rcode) {
        return this.buildErrorMessage(query.getHeader(), rcode, query.getQuestion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void TCPclient(Socket s) {
        try {
            byte[] response;
            InputStream is = s.getInputStream();
            DataInputStream dataIn = new DataInputStream(is);
            int inLength = dataIn.readUnsignedShort();
            byte[] in = new byte[inLength];
            dataIn.readFully(in);
            try {
                Message query = new Message(in);
                response = this.generateReply(query, in, in.length, s);
                if (response == null) {
                    return;
                }
            }
            catch (IOException ignored) {
                response = this.formerrMessage(in);
            }
            DataOutputStream dataOut = new DataOutputStream(s.getOutputStream());
            dataOut.writeShort(response.length);
            dataOut.write(response);
            return;
        }
        catch (IOException e) {
            LOG.warn("TCPclient(" + DnsServer.addrport(s.getLocalAddress(), s.getLocalPort()) + ").", (Throwable)e);
            try {
                s.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
        finally {
            try {
                s.close();
            }
            catch (IOException ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serveTCP(InetSocketAddress address) {
        try {
            ServerSocket sock = new ServerSocket(address.getPort(), 128, address.getAddress());
            Set<Closeable> set = this._closeables;
            synchronized (set) {
                this._closeables.add(sock);
            }
            while (!Thread.currentThread().isInterrupted()) {
                final Socket s = this.accept(sock);
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        DnsServer.this.TCPclient(s);
                    }
                });
                this._threads.add(thread);
                thread.start();
            }
        }
        catch (InterruptedIOException ignored) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            LOG.warn("serveTCP(" + DnsServer.addrport(address.getAddress(), address.getPort()) + ")", (Throwable)e);
        }
    }

    @Nonnull
    private Socket accept(@Nonnull ServerSocket sock) throws IOException {
        try {
            return sock.accept();
        }
        catch (SocketException e) {
            if (sock.isClosed()) {
                InterruptedIOException toThrow = new InterruptedIOException();
                toThrow.initCause(e);
                throw toThrow;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serveUDP(InetSocketAddress address) {
        try {
            DatagramSocket sock = new DatagramSocket(address.getPort(), address.getAddress());
            Set<Closeable> set = this._closeables;
            synchronized (set) {
                this._closeables.add(sock);
            }
            int udpLength = 512;
            byte[] in = new byte[512];
            DatagramPacket indp = new DatagramPacket(in, in.length);
            DatagramPacket outdp = null;
            while (!Thread.currentThread().isInterrupted()) {
                byte[] response;
                indp.setLength(in.length);
                DnsServer.receive(sock, indp);
                try {
                    Message query = new Message(in);
                    response = this.generateReply(query, in, indp.getLength(), null);
                    if (response == null) {
                        continue;
                    }
                }
                catch (IOException ignored) {
                    response = this.formerrMessage(in);
                }
                if (outdp == null) {
                    outdp = new DatagramPacket(response, response.length, indp.getAddress(), indp.getPort());
                } else {
                    outdp.setData(response);
                    outdp.setLength(response.length);
                    outdp.setAddress(indp.getAddress());
                    outdp.setPort(indp.getPort());
                }
                sock.send(outdp);
            }
        }
        catch (InterruptedIOException ignored) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            LOG.warn("serveUDP(" + DnsServer.addrport(address.getAddress(), address.getPort()) + ")", (Throwable)e);
        }
    }

    private static void receive(@Nonnull DatagramSocket sock, @Nonnull DatagramPacket indp) throws IOException {
        try {
            sock.receive(indp);
        }
        catch (SocketException e) {
            if (sock.isClosed()) {
                InterruptedIOException toThrow = new InterruptedIOException();
                toThrow.initCause(e);
                throw toThrow;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTCP(final InetSocketAddress address) {
        DnsServer dnsServer = this;
        synchronized (dnsServer) {
            this.assertNotClosed();
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    DnsServer.this.serveTCP(address);
                }
            });
            this._threads.add(t);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUDP(final InetSocketAddress address) {
        DnsServer dnsServer = this;
        synchronized (dnsServer) {
            this.assertNotClosed();
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    DnsServer.this.serveUDP(address);
                }
            });
            this._threads.add(t);
            t.start();
        }
    }

    protected void assertNotClosed() {
        if (this._closed) {
            throw new IllegalStateException("This server was already closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        DnsServer dnsServer = this;
        synchronized (dnsServer) {
            this._closed = true;
            Set<Closeable> set = this._closeables;
            synchronized (set) {
                for (Closeable closeable : this._closeables) {
                    IOUtils.closeQuietly((Closeable)closeable);
                }
            }
            for (Thread thread : this._threads) {
                do {
                    thread.interrupt();
                    try {
                        thread.join(10L);
                    }
                    catch (InterruptedException ignored) {
                        LOG.info("Got interrupted and could not wait for end of '" + thread + "'.");
                        Thread.currentThread().interrupt();
                    }
                } while (!Thread.currentThread().isInterrupted() && thread.isAlive());
            }
        }
    }
}

