/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.dns;

import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.echocat.jomon.net.dns.RecordUtils;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.Zone;

public class ZoneUtils {
    @Nonnull
    public static Zone zone(@Nonnull String name, @Nonnegative long serial, Record ... records) {
        return ZoneUtils.zone(name, RecordUtils.soa(name, name, serial), RecordUtils.ns(name, "ns1." + name), records);
    }

    @Nonnull
    public static Zone zone(@Nonnull String name, @Nonnull SOARecord soa, @Nonnull NSRecord nsRecord, Record ... records) {
        Record[] target = new Record[(records != null ? records.length : 0) + 2];
        target[0] = soa;
        target[1] = nsRecord;
        if (records != null) {
            for (int i = 0; i < records.length; ++i) {
                target[i + 2] = records[i];
            }
        }
        return ZoneUtils.zone(Name.fromConstantString((String)name), target);
    }

    @Nonnull
    public static Zone zone(@Nonnull Name name, Record ... records) {
        try {
            return new Zone(name, records != null ? records : new Record[]{});
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not create a zone from " + name + " and " + Arrays.toString(records) + ".", e);
        }
    }

    private ZoneUtils() {
    }
}

