/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.echocat.jomon.runtime.util.Duration;

public class DateTimeUtils {
    public static final String ISO_PATTERN = "yyyy-MM-dd'T'HH:mm:ssZ";

    @Nonnull
    public static Date now() {
        return new Date();
    }

    @Nonnull
    public static Date addWeeks(@Nonnull Date date, @Nonnegative int weeks) {
        return DateTimeUtils.addDays(date, weeks * 7);
    }

    @Nonnull
    public static Date addDays(@Nonnull Date date, @Nonnegative int days) {
        return DateTimeUtils.addHours(date, days * 24);
    }

    @Nonnull
    public static Date addHours(@Nonnull Date date, @Nonnegative int hours) {
        return DateTimeUtils.addMinutes(date, hours * 60);
    }

    @Nonnull
    public static Date addMinutes(@Nonnull Date date, @Nonnegative int minutes) {
        return DateTimeUtils.addSeconds(date, minutes * 60);
    }

    @Nonnull
    public static Date addSeconds(@Nonnull Date date, @Nonnegative int seconds) {
        return DateTimeUtils.addMilliseconds(date, seconds * 1000);
    }

    @Nonnull
    public static Date addMilliseconds(@Nonnull Date date, @Nonnegative int milliseconds) {
        return new Date(date.getTime() + (long)milliseconds);
    }

    @Nonnull
    public static Date nowBefore(@Nonnull String duration) {
        return DateTimeUtils.nowBefore(new Duration(duration));
    }

    @Nonnull
    public static Date nowBefore(@Nonnull Duration duration) {
        return new Date(System.currentTimeMillis() - duration.in(TimeUnit.MILLISECONDS));
    }

    @Nonnull
    public static Date nowIn(@Nonnull String duration) {
        return DateTimeUtils.nowIn(new Duration(duration));
    }

    @Nonnull
    public static Date nowIn(@Nonnull Duration duration) {
        return new Date(System.currentTimeMillis() + duration.in(TimeUnit.MILLISECONDS));
    }

    @Nonnull
    public static Date parseIsoDate(@Nonnull String asString) throws IllegalArgumentException {
        try {
            return new SimpleDateFormat(ISO_PATTERN).parse(asString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not parse: " + asString + ", it does not match pattern: " + ISO_PATTERN, e);
        }
    }

    private DateTimeUtils() {
    }
}

