/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.date;

import java.util.Date;
import javax.annotation.Nonnull;
import org.apache.commons.math3.random.RandomData;
import org.apache.commons.math3.random.RandomDataImpl;
import org.echocat.jomon.runtime.date.DateRange;
import org.echocat.jomon.runtime.date.DateRangeRequirement;
import org.echocat.jomon.runtime.date.DateRequirement;
import org.echocat.jomon.runtime.date.ExactDateRequirement;
import org.echocat.jomon.runtime.generation.Generator;

public class DateGenerator
implements Generator<Date, DateRequirement> {
    private static final RandomData RANDOM = new RandomDataImpl();
    private static final DateGenerator INSTANCE = new DateGenerator();

    @Nonnull
    public static Date generateDate(@Nonnull DateRequirement requirement) {
        return INSTANCE.generate(requirement);
    }

    @Override
    @Nonnull
    public Date generate(@Nonnull DateRequirement requirement) {
        Date date;
        if (requirement instanceof ExactDateRequirement) {
            date = this.generateExact((ExactDateRequirement)requirement);
        } else if (requirement instanceof DateRangeRequirement) {
            date = this.generateInRange((DateRangeRequirement)requirement);
        } else {
            throw new IllegalArgumentException("Don't know how to handle requirement: " + requirement);
        }
        return date;
    }

    @Nonnull
    protected Date generateExact(@Nonnull ExactDateRequirement requirement) {
        return (Date)requirement.getValue();
    }

    @Nonnull
    protected Date generateInRange(@Nonnull DateRangeRequirement requirement) {
        DateRange range = (DateRange)requirement.getValue();
        Date from = (Date)range.getFrom();
        long fromAsTimestamp = from != null ? from.getTime() : 0L;
        Date to = (Date)range.getTo();
        long toAsTimestamp = to != null ? to.getTime() : Long.MAX_VALUE;
        long randomTimestamp = RANDOM.nextSecureLong(fromAsTimestamp, toAsTimestamp);
        return new Date(randomTimestamp);
    }
}

