/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jomon.runtime.i18n.CombinedResourceBundle;
import org.echocat.jomon.runtime.system.DynamicClassLoader;

@ThreadSafe
public class RecursiveResourceBundleFactory {
    private final Map<Class<?>, Map<Locale, ResourceBundle>> _typeToNotRecursiveBundleCache = new WeakHashMap();
    private final Map<ClassLoader, Map<String, Map<Locale, ResourceBundle>>> _classLoaderToPackageNameAndNotRecursiveBundleCache = new WeakHashMap<ClassLoader, Map<String, Map<Locale, ResourceBundle>>>();
    private Charset _charset = Charset.forName("UTF-8");

    @Nonnull
    public Charset getCharset() {
        return this._charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharset(@Nonnull Charset charset) {
        RecursiveResourceBundleFactory recursiveResourceBundleFactory = this;
        synchronized (recursiveResourceBundleFactory) {
            this._charset = charset;
            this.flushAllEntries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushEntriesOf(@Nonnull ClassLoader classLoader) {
        RecursiveResourceBundleFactory recursiveResourceBundleFactory = this;
        synchronized (recursiveResourceBundleFactory) {
            this._classLoaderToPackageNameAndNotRecursiveBundleCache.remove(classLoader);
            Iterator<Class<?>> i = this._typeToNotRecursiveBundleCache.keySet().iterator();
            while (i.hasNext()) {
                Class<?> type = i.next();
                if (!classLoader.equals(type.getClassLoader())) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAllEntries() {
        RecursiveResourceBundleFactory recursiveResourceBundleFactory = this;
        synchronized (recursiveResourceBundleFactory) {
            this._typeToNotRecursiveBundleCache.clear();
            this._classLoaderToPackageNameAndNotRecursiveBundleCache.clear();
        }
    }

    @Nonnull
    public ResourceBundle getFor(@Nonnull Class<?> type, @Nullable Locale locale) {
        return this.getFor(type, null, locale);
    }

    @Nonnull
    public ResourceBundle getFor(@Nonnull Class<?> type, @Nullable ClassLoader classLoader, @Nullable Locale locale) {
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        for (Class<?> current = type; current != null && !Object.class.equals(current); current = current.getSuperclass()) {
            bundles.addAll(this.getAllRecursivelyWithNoInheritanceFor(current, classLoader, locale));
        }
        return new CombinedResourceBundle(bundles);
    }

    @Nonnull
    protected List<ResourceBundle> getAllRecursivelyWithNoInheritanceFor(@Nonnull Class<?> type, @Nullable ClassLoader classLoader, @Nullable Locale locale) {
        ClassLoader targetClassLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        if (targetClassLoader != null) {
            ResourceBundle bundleForType = this.tryFindFor(type, locale, targetClassLoader);
            if (bundleForType != null) {
                bundles.add(bundleForType);
            }
            bundles.addAll(this.getAllRecursivelyFor(type.getPackage(), locale, targetClassLoader));
        }
        return bundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected ResourceBundle tryFindFor(@Nonnull Class<?> type, @Nullable Locale forLocale, @Nonnull ClassLoader withClassLoader) {
        ResourceBundle bundle;
        String fileName = this.buildMessagePropertiesFileNameFor(type, forLocale);
        if (withClassLoader instanceof DynamicClassLoader && ((DynamicClassLoader)((Object)withClassLoader)).isDynamic()) {
            bundle = this.loadBundles(fileName, withClassLoader);
        } else {
            RecursiveResourceBundleFactory recursiveResourceBundleFactory = this;
            synchronized (recursiveResourceBundleFactory) {
                Map<Locale, ResourceBundle> localeToResourceBundleCache = this._typeToNotRecursiveBundleCache.get(type);
                if (localeToResourceBundleCache == null) {
                    localeToResourceBundleCache = new HashMap<Locale, ResourceBundle>();
                    this._typeToNotRecursiveBundleCache.put(type, localeToResourceBundleCache);
                }
                if (localeToResourceBundleCache.containsKey(forLocale)) {
                    bundle = localeToResourceBundleCache.get(forLocale);
                } else {
                    bundle = this.loadBundles(fileName, withClassLoader);
                    localeToResourceBundleCache.put(forLocale, bundle);
                }
            }
        }
        return bundle;
    }

    @Nonnull
    protected List<ResourceBundle> getAllRecursivelyFor(@Nonnull Package aPackage, @Nullable Locale forLocale, @Nonnull ClassLoader withClassLoader) {
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        String current = aPackage.getName();
        while (current != null) {
            int lastDot;
            ResourceBundle bundle = this.tryFindFor(current, forLocale, withClassLoader);
            if (bundle != null) {
                bundles.add(bundle);
            }
            if ((lastDot = current.lastIndexOf(46)) >= 0) {
                current = current.substring(0, lastDot);
                continue;
            }
            if (!current.isEmpty()) {
                current = "";
                continue;
            }
            current = null;
        }
        return bundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected ResourceBundle tryFindFor(@Nonnull String aPackageName, @Nullable Locale forLocale, @Nonnull ClassLoader withClassLoader) {
        ResourceBundle bundle;
        String fileName = this.buildMessagePropertiesFileNameFor(aPackageName, forLocale);
        if (withClassLoader instanceof DynamicClassLoader && ((DynamicClassLoader)((Object)withClassLoader)).isDynamic()) {
            bundle = this.loadBundles(fileName, withClassLoader);
        } else {
            RecursiveResourceBundleFactory recursiveResourceBundleFactory = this;
            synchronized (recursiveResourceBundleFactory) {
                Map<Locale, ResourceBundle> localeToResourceBundle;
                Map<String, Map<Locale, ResourceBundle>> packageNameToBundle = this._classLoaderToPackageNameAndNotRecursiveBundleCache.get(withClassLoader);
                if (packageNameToBundle == null) {
                    packageNameToBundle = new HashMap<String, Map<Locale, ResourceBundle>>();
                    this._classLoaderToPackageNameAndNotRecursiveBundleCache.put(withClassLoader, packageNameToBundle);
                }
                if ((localeToResourceBundle = packageNameToBundle.get(aPackageName)) == null) {
                    localeToResourceBundle = new HashMap<Locale, ResourceBundle>();
                    packageNameToBundle.put(aPackageName, localeToResourceBundle);
                }
                if (localeToResourceBundle.containsKey(forLocale)) {
                    bundle = localeToResourceBundle.get(forLocale);
                } else {
                    bundle = this.loadBundles(fileName, withClassLoader);
                    localeToResourceBundle.put(forLocale, bundle);
                }
            }
        }
        return bundle;
    }

    @Nullable
    protected ResourceBundle loadBundles(@Nonnull String withName, @Nonnull ClassLoader from) {
        Enumeration<URL> i;
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        try {
            i = from.getResources(withName);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not find all resourceBundles with name '" + withName + "' in " + from + ".", e);
        }
        while (i.hasMoreElements()) {
            URL propertiesUrl = i.nextElement();
            try {
                InputStream is = propertiesUrl.openStream();
                Throwable throwable = null;
                try {
                    InputStreamReader reader = new InputStreamReader(is, this._charset);
                    Throwable throwable2 = null;
                    try {
                        bundles.add(new PropertyResourceBundle(reader));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((Reader)reader).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load resourceBundle from '" + propertiesUrl + "'.", e);
            }
        }
        return bundles.isEmpty() ? null : new CombinedResourceBundle(bundles);
    }

    @Nonnull
    protected String buildMessagePropertiesFileNameFor(@Nonnull Class<?> type, @Nullable Locale locale) {
        return type.getName().replace('.', '/') + this.buildMessagePropertiesFileNameSuffixFor(locale);
    }

    @Nonnull
    protected String buildMessagePropertiesFileNameFor(@Nonnull String packageName, @Nullable Locale locale) {
        return packageName.replace('.', '/') + (packageName.isEmpty() ? "" : "/") + "messages" + this.buildMessagePropertiesFileNameSuffixFor(locale);
    }

    @Nonnull
    protected String buildMessagePropertiesFileNameSuffixFor(@Nullable Locale locale) {
        StringBuilder sb = new StringBuilder();
        if (locale != null && !StringUtils.isEmpty((CharSequence)locale.getLanguage())) {
            sb.append('_').append(locale);
        }
        sb.append(".properties");
        return sb.toString();
    }
}

