/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import java.io.Reader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.logging.LogbackBasedLoggingEnvironmentConfiguration;
import org.echocat.jomon.runtime.logging.LoggingEnvironment;
import org.echocat.jomon.runtime.logging.Slf4jUtils;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactoryRegistry;
import org.xml.sax.InputSource;

public class LogbackBasedLoggingEnvironment
implements LoggingEnvironment {
    @Nullable
    private LoggerFactoryRegistry.Registration _loggerFactoryRegistration;
    @Nullable
    private LoggerContext _loggerContext;
    @Nullable
    private Slf4jUtils.Installation _installation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(@Nonnull LogbackBasedLoggingEnvironmentConfiguration with) {
        LogbackBasedLoggingEnvironment logbackBasedLoggingEnvironment = this;
        synchronized (logbackBasedLoggingEnvironment) {
            if (this._loggerFactoryRegistration == null) {
                this._loggerContext = this.createContextFor(with);
                this._loggerFactoryRegistration = LoggerFactoryRegistry.register((ILoggerFactory)this._loggerContext);
                if (with.isInstallSl4jRequired()) {
                    this._installation = Slf4jUtils.tryInstallSlf4jBridges((ILoggerFactory)this._loggerContext);
                }
            }
        }
    }

    @Nonnull
    protected LoggerContext createContextFor(@Nonnull LogbackBasedLoggingEnvironmentConfiguration requirement) {
        LoggerContext context = new LoggerContext();
        this.configure(context, requirement);
        return context;
    }

    @Nonnull
    protected void configure(@Nonnull LoggerContext context, @Nonnull LogbackBasedLoggingEnvironmentConfiguration requirement) {
        try (Reader reader = requirement.openAsReader();){
            this.configure(context, requirement, reader);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not configure log4j.", e);
        }
    }

    protected void configure(@Nonnull LoggerContext context, @Nonnull LogbackBasedLoggingEnvironmentConfiguration with, @Nonnull Reader reader) throws Exception {
        JoranConfigurator result = new JoranConfigurator();
        result.setContext((Context)context);
        context.reset();
        result.doConfigure(new InputSource(reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        LogbackBasedLoggingEnvironment logbackBasedLoggingEnvironment = this;
        synchronized (logbackBasedLoggingEnvironment) {
            try {
                try {
                    ResourceUtils.closeQuietly((AutoCloseable)this._installation);
                }
                finally {
                    this._installation = null;
                }
            }
            finally {
                try {
                    try {
                        ResourceUtils.closeQuietly((AutoCloseable)this._loggerFactoryRegistration);
                    }
                    finally {
                        this._loggerFactoryRegistration = null;
                    }
                }
                finally {
                    this._loggerContext = null;
                }
            }
        }
    }

    @Nonnull
    protected ILoggerFactory loggerFactory() {
        LoggerContext loggerFactory = this._loggerContext;
        if (loggerFactory == null) {
            throw new IllegalStateException("Logging environment currently not initialized.");
        }
        return loggerFactory;
    }

    @Override
    @Nonnull
    public Logger getLogger(@Nonnull String name) {
        return this.loggerFactory().getLogger(name);
    }

    @Override
    @Nonnull
    public Logger getLogger(@Nonnull Class<?> type) {
        return this.getLogger(type.getName());
    }
}

