/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.math;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.echocat.jomon.runtime.util.Duration;

public class OverPeriodCounter {
    protected static final int MAX_NUMBER_OF_MEASURE_POINTS = 10000;
    private final long _measurePeriod;
    private final long _resolution;
    private final Long[] _measuredCounts;
    private final Long[] _measuredBaseTimes;

    public OverPeriodCounter(@Nonnull Duration measurePeriod, @Nonnull Duration resolution) {
        if (measurePeriod.isLessThan(resolution)) {
            throw new IllegalArgumentException("The given measure period have to be larger or equal than the resolution.");
        }
        this._measurePeriod = measurePeriod.in(TimeUnit.MILLISECONDS);
        this._resolution = resolution.in(TimeUnit.MILLISECONDS) - measurePeriod.in(TimeUnit.MILLISECONDS) % resolution.in(TimeUnit.MILLISECONDS);
        long measurePointsCount = this._measurePeriod / this._resolution;
        if (measurePointsCount > 10000L) {
            throw new IllegalArgumentException("The difference between measurePeriod and resolution is to high. Do not reach measurePeriod/resolution > 10000.");
        }
        this._measuredCounts = new Long[(int)measurePointsCount];
        this._measuredBaseTimes = new Long[(int)measurePointsCount];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record() {
        long currentTime = System.currentTimeMillis();
        long currentPositionInPeriod = currentTime % this._measurePeriod;
        int i = (int)(currentPositionInPeriod / this._resolution);
        long measuredPeriodBaseTime = currentTime / this._measurePeriod * this._measurePeriod;
        long measuredBaseTime = measuredPeriodBaseTime + (long)i * this._resolution;
        OverPeriodCounter overPeriodCounter = this;
        synchronized (overPeriodCounter) {
            if (this._measuredCounts[i] == null || this._measuredBaseTimes[i] == null || this._measuredBaseTimes[i] != measuredBaseTime && this._measuredBaseTimes[i] + this._measurePeriod < currentTime) {
                this._measuredCounts[i] = 0L;
                this._measuredBaseTimes[i] = measuredBaseTime;
            }
            Long[] longArray = this._measuredCounts;
            Long l = longArray[i];
            Long l2 = longArray[i] = Long.valueOf(longArray[i] + 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public long getAllOfMeasurePeriod() {
        long currentTime = System.currentTimeMillis();
        long sumOfMeasuredValueCounts = 0L;
        OverPeriodCounter overPeriodCounter = this;
        synchronized (overPeriodCounter) {
            for (int i = 0; i < this._measuredCounts.length; ++i) {
                if (this._measuredBaseTimes[i] == null || this._measuredBaseTimes[i] + this._measurePeriod < currentTime) continue;
                sumOfMeasuredValueCounts += this._measuredCounts[i].longValue();
            }
        }
        return sumOfMeasuredValueCounts;
    }

    @Nonnegative
    public long get() {
        return this.getAllOfMeasurePeriod() / (long)this._measuredCounts.length;
    }

    @Nonnegative
    public double getAsDouble() {
        return (double)this.getAllOfMeasurePeriod() / (double)this._measuredCounts.length;
    }

    @Nonnull
    public Duration getMeasurePeriod() {
        return new Duration(this._measurePeriod);
    }

    @Nonnull
    public Duration getResolution() {
        return new Duration(this._resolution);
    }

    @Nonnegative
    public int getNumberOfMeasureSlots() {
        return this._measuredCounts.length;
    }

    public String toString() {
        return this.get() + "/" + this.getResolution();
    }
}

