/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.numbers;

import javax.annotation.Nonnull;
import org.apache.commons.math3.random.RandomData;
import org.apache.commons.math3.random.RandomDataImpl;
import org.echocat.jomon.runtime.generation.Generator;
import org.echocat.jomon.runtime.numbers.ExactShortRequirement;
import org.echocat.jomon.runtime.numbers.NumberRequirement;
import org.echocat.jomon.runtime.numbers.ShortRange;
import org.echocat.jomon.runtime.numbers.ShortRangeRequirement;

public class ShortGenerator
implements Generator<Short, NumberRequirement<Short>> {
    private static final RandomData RANDOM = new RandomDataImpl();
    private static final ShortGenerator INSTANCE = new ShortGenerator();

    @Nonnull
    public static Short generateShort(@Nonnull NumberRequirement<Short> requirement) {
        return INSTANCE.generate(requirement);
    }

    @Override
    @Nonnull
    public Short generate(@Nonnull NumberRequirement<Short> requirement) {
        Short Short2;
        if (requirement instanceof ExactShortRequirement) {
            Short2 = this.generateExact((ExactShortRequirement)requirement);
        } else if (requirement instanceof ShortRangeRequirement) {
            Short2 = this.generateInRange((ShortRangeRequirement)requirement);
        } else {
            throw new IllegalArgumentException("Don't know how to handle requirement: " + requirement);
        }
        return Short2;
    }

    @Nonnull
    protected Short generateExact(@Nonnull ExactShortRequirement requirement) {
        return (Short)requirement.getValue();
    }

    @Nonnull
    protected Short generateInRange(@Nonnull ShortRangeRequirement requirement) {
        ShortRange range = (ShortRange)requirement.getValue();
        return (short)RANDOM.nextSecureInt((int)((Short)range.getFrom()).shortValue(), (int)((Short)range.getTo()).shortValue());
    }
}

