/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import com.google.common.base.Predicate;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.CollectionUtils;

public class BaseIncludesExcludesPredicate<F, V, T extends BaseIncludesExcludesPredicate<F, V, T>>
implements Predicate<V> {
    @Nullable
    private Collection<? extends F> _includes;
    @Nullable
    private Collection<? extends F> _excludes;

    protected boolean isIncluded(@Nonnull V input) {
        Collection<F> includes = this.getIncludes();
        return includes == null || includes.isEmpty() || this.isIncluded(input, includes);
    }

    protected boolean isIncluded(@Nonnull V what, @Nonnull Collection<? extends F> by) {
        return this.isContained(what, by);
    }

    protected boolean isExcluded(@Nonnull V input) {
        Collection<F> excludes = this.getExcludes();
        return excludes != null && !excludes.isEmpty() && this.isExcluded(input, excludes);
    }

    protected boolean isExcluded(@Nonnull V what, @Nonnull Collection<? extends F> by) {
        return this.isContained(what, by);
    }

    protected boolean isContained(@Nonnull V what, @Nonnull Collection<? extends F> inFilterRule) {
        return inFilterRule.contains(what);
    }

    public boolean apply(@Nullable V input) {
        return input != null && this.isIncluded(input) && !this.isExcluded(input);
    }

    @Nullable
    public Collection<? extends F> getIncludes() {
        return this._includes;
    }

    public void setIncludes(@Nullable Collection<? extends F> includes) {
        this._includes = includes;
    }

    @Nullable
    public Collection<? extends F> getExcludes() {
        return this._excludes;
    }

    public void setExcludes(@Nullable Collection<? extends F> excludes) {
        this._excludes = excludes;
    }

    @Nonnull
    public T including(F ... includes) {
        return this.including((Collection<F>)(includes != null ? CollectionUtils.asImmutableList(includes) : null));
    }

    @Nonnull
    public T including(@Nullable Collection<F> includes) {
        this.setIncludes(includes);
        return this.thisInstance();
    }

    @Nonnull
    public T excluding(F ... excludes) {
        return this.excluding((Collection<F>)(excludes != null ? CollectionUtils.asImmutableList(excludes) : null));
    }

    @Nonnull
    public T excluding(@Nullable Collection<F> includes) {
        this.setExcludes(includes);
        return this.thisInstance();
    }

    @Nonnull
    protected T thisInstance() {
        return (T)this;
    }
}

