/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.util.Entry;
import org.echocat.jomon.runtime.util.Key;
import org.echocat.jomon.runtime.util.MutableValueProvider;
import org.echocat.jomon.runtime.util.ValueProvider;

public class ValueProviderUtils {
    @Nonnull
    public static final ValueProvider EMPTY_VALUE_PROVIDER = new EmptyValueProvider();

    private ValueProviderUtils() {
    }

    @Nonnull
    public static ValueProvider emptyValueProvider() {
        return EMPTY_VALUE_PROVIDER;
    }

    @Nonnull
    public static ValueProvider asImmutableValueProvider(@Nullable ValueProvider original) {
        return original != null ? new ImmutableValueProvider(original) : ValueProviderUtils.emptyValueProvider();
    }

    @Nonnull
    public static ValueProvider asImmutableValueProvider(Object ... keyToValue) {
        Map asMap = CollectionUtils.asImmutableMap(keyToValue);
        return ValueProviderUtils.asImmutableValueProvider(asMap);
    }

    @Nonnull
    public static ValueProvider asImmutableValueProvider(@Nullable Map<Key<?>, ?> keyToValue) {
        return new ValueProvider.Impl(keyToValue != null ? keyToValue : Collections.emptyMap());
    }

    @Nonnull
    public static MutableValueProvider asValueProvider(Object ... keyToValue) {
        MutableValueProvider.Impl result = new MutableValueProvider.Impl();
        ValueProviderUtils.setAll((MutableValueProvider)result, keyToValue);
        return result;
    }

    @Nonnull
    public static MutableValueProvider asValueProvider(@Nullable Map<Key<?>, ?> keyToValue) {
        MutableValueProvider.Impl result = new MutableValueProvider.Impl();
        ValueProviderUtils.setAll((MutableValueProvider)result, keyToValue);
        return result;
    }

    @Nonnull
    public static MutableValueProvider asValueProvider(@Nullable ValueProvider original) {
        MutableValueProvider.Impl result = new MutableValueProvider.Impl();
        ValueProviderUtils.setAll((MutableValueProvider)result, original);
        return result;
    }

    public static boolean contains(@Nullable ValueProvider provider, @Nonnull Key<?> key) {
        return provider != null ? provider.contains(key) : key.getDefaultValue() != null;
    }

    public static <T> T get(@Nullable ValueProvider provider, @Nonnull Key<T> key) {
        return ValueProviderUtils.get(provider, key, key.getDefaultValue());
    }

    public static <T> T get(@Nullable ValueProvider provider, @Nonnull Key<T> key, @Nullable T defaultValue) {
        T result = provider != null ? provider.get(key, defaultValue) : defaultValue;
        return result;
    }

    public static boolean isEnabled(@Nullable ValueProvider provider, @Nonnull Key<Boolean> key) {
        return ValueProviderUtils.isEnabled(provider, key, key.getDefaultValue());
    }

    public static boolean isEnabled(@Nullable ValueProvider provider, @Nonnull Key<Boolean> key, boolean defaultValue) {
        return Boolean.TRUE.equals(ValueProviderUtils.get(provider, key, defaultValue));
    }

    public static <T> boolean is(@Nullable ValueProvider valueProvider, @Nonnull Key<T> key, @Nullable T expected, @Nullable T defaultValue) {
        T value = ValueProviderUtils.get(valueProvider, key, defaultValue);
        return expected != null ? expected.equals(value) : value == null;
    }

    public static <T> boolean is(@Nullable ValueProvider valueProvider, @Nonnull Key<T> key, @Nullable T expected) {
        return ValueProviderUtils.is(valueProvider, key, expected, key.getDefaultValue());
    }

    public static <T> void set(@Nonnull MutableValueProvider provider, @Nonnull Key<T> key, @Nullable T value) {
        provider.set(key, value);
    }

    public static <T> void remove(@Nonnull MutableValueProvider provider, @Nonnull Key<T> key) {
        provider.remove(key);
    }

    public static void setAll(@Nonnull MutableValueProvider target, @Nullable ValueProvider of) {
        if (of != null) {
            for (Entry keyAndValue : of) {
                target.set((Key)keyAndValue.getKey(), keyAndValue.getValue());
            }
        }
    }

    public static void setAll(@Nonnull MutableValueProvider target, @Nullable Map<Key<?>, ?> keyToValue) {
        if (keyToValue != null) {
            for (Map.Entry<Key<?>, ?> keyAndValue : keyToValue.entrySet()) {
                target.set(keyAndValue.getKey(), keyAndValue.getValue());
            }
        }
    }

    public static void setAll(@Nonnull MutableValueProvider target, Object ... keyToValue) {
        if (keyToValue != null) {
            int length = keyToValue.length;
            if (length % 2 == 1) {
                throw new IllegalArgumentException("You must provide an even number of arguments.");
            }
            for (int i = 0; i < length; i += 2) {
                target.set((Key)keyToValue[i], keyToValue[i + 1]);
            }
        }
    }

    @ThreadSafe
    @Immutable
    public static class EmptyValueProvider
    extends ValueProvider.Support {
        @Override
        public boolean contains(@Nonnull Key<?> key) {
            return key.getDefaultValue() != null;
        }

        @Override
        @Nullable
        public <T> T get(@Nonnull Key<T> key) {
            return key.getDefaultValue();
        }

        @Override
        @Nullable
        public <T> T get(@Nonnull Key<T> key, @Nullable T defaultValue) {
            return defaultValue;
        }

        @Override
        public Iterator<Entry<Key<Object>, Object>> iterator() {
            return CollectionUtils.emptyIterator();
        }

        @Override
        public Map<Key<Object>, Object> toMap() {
            return Collections.emptyMap();
        }
    }

    @ThreadSafe
    @Immutable
    public static class ImmutableValueProvider
    extends ValueProvider.Support {
        @Nonnull
        private final ValueProvider _original;

        public ImmutableValueProvider(@Nonnull ValueProvider original) {
            this._original = original;
        }

        @Override
        public boolean contains(@Nonnull Key<?> key) {
            return this._original.contains(key);
        }

        @Override
        @Nullable
        public <T> T get(@Nonnull Key<T> key) {
            return this._original.get(key);
        }

        @Override
        @Nullable
        public <T> T get(@Nonnull Key<T> key, @Nullable T defaultValue) {
            return this._original.get(key, defaultValue);
        }

        @Override
        public Iterator<Entry<Key<Object>, Object>> iterator() {
            final Iterator i = this._original.iterator();
            return new Iterator<Entry<Key<Object>, Object>>(){

                @Override
                public boolean hasNext() {
                    return i.hasNext();
                }

                @Override
                public Entry<Key<Object>, Object> next() {
                    return (Entry)i.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Map<Key<Object>, Object> toMap() {
            HashMap result = new HashMap();
            for (Entry keyAndValue : this._original) {
                result.put(keyAndValue.getKey(), keyAndValue.getValue());
            }
            return CollectionUtils.asImmutableMap(result);
        }
    }
}

