/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.io.ChunkAwareSerializer;
import org.echocat.jomon.runtime.io.Serializers;
import org.echocat.jomon.runtime.io.StreamUtils;
import org.echocat.jomon.runtime.iterators.CloseableIterator;
import org.echocat.jomon.runtime.iterators.ConvertingIterator;
import org.echocat.jomon.runtime.util.ByteCount;
import org.echocat.jomon.runtime.util.ResourceUtils;

@ThreadSafe
public class GeneratedProcessRegistry<ID, P extends GeneratedProcess<?, ID>>
implements AutoCloseable {
    @Nonnull
    protected static final String DEFAULT_IDS_FILE_DIRECTORY_PATH_PREFIX = System.getProperty("user.home", ".") + File.separator + ".parentProcessRegistry";
    @Nonnull
    private final Map<ID, Long> _processIdToFilePosition = new HashMap<ID, Long>();
    @Nonnull
    private final Set<Long> _freeFilePositions = new HashSet<Long>();
    @Nonnull
    private final File _file;
    @Nonnull
    private final RandomAccessFile _access;
    private final long _parentLocalProcessId;
    @Nonnull
    private final String _type;
    @Nonnull
    private final ChunkAwareSerializer<ID> _idSerializer;
    @Nonnull
    private final Class<ID> _idType;

    public GeneratedProcessRegistry(long parentLocalProcessId, @Nonnull String type, @Nonnull Class<ID> idType) {
        this._parentLocalProcessId = parentLocalProcessId;
        this._type = type;
        this._idType = idType;
        File idsFileDirectory = GeneratedProcessRegistry.getIdsFileDirectoryFor(this._type);
        this._file = GeneratedProcessRegistry.getIdsFileFor(idsFileDirectory, parentLocalProcessId);
        this._access = this.openIdsFile(this._file);
        this._idSerializer = Serializers.getChunkAwareSerializerOf(idType);
    }

    @Nonnull
    protected ByteCount getChunkSizeFor(@Nonnull Class<ID> idType, @Nullable ChunkAwareSerializer<ID> idSerializer) {
        long byteCount;
        if (idType == Long.class) {
            byteCount = 8L;
        } else if (idType == Integer.class) {
            byteCount = 4L;
        } else if (idType == Short.class) {
            byteCount = 2L;
        } else if (idType == Byte.class) {
            byteCount = 1L;
        } else if (idSerializer != null) {
            byteCount = idSerializer.getChunkSize();
        } else {
            throw new UnsupportedOperationException("This class does not support an idType '" + idType.getName() + "'.");
        }
        return ByteCount.byteCountOf((long)byteCount);
    }

    @Nonnull
    public String getType() {
        return this._type;
    }

    public long getParentLocalProcessId() {
        return this._parentLocalProcessId;
    }

    @Nonnull
    protected RandomAccessFile openIdsFile(@Nonnull File file) {
        try {
            return new RandomAccessFile(file, "rw");
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Could not open ids file (" + file + ").", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(@Nonnull P process) {
        Object id;
        if (process.isDaemon() && (id = process.getId()) != null) {
            GeneratedProcessRegistry generatedProcessRegistry = this;
            synchronized (generatedProcessRegistry) {
                if (!this._processIdToFilePosition.containsKey(id)) {
                    this.registerUnknownProcessWith(id);
                    this.startAutomaticDeRegistrationFor(process);
                }
            }
        }
    }

    protected void startAutomaticDeRegistrationFor(@Nonnull P process) {
        Thread waiter = new Thread((Runnable)new WaitForEnd(this, process), "Wait for end of " + process);
        waiter.setDaemon(true);
        waiter.start();
    }

    @GuardedBy(value="this")
    protected void registerUnknownProcessWith(@Nonnull ID id) {
        long position = this.getFreePosition();
        try {
            this._access.seek(position);
            this.writeIdToChunk(id);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write id " + id + " at position " + position + " in " + this._access + ".", e);
        }
        this._processIdToFilePosition.put(id, position);
        this._freeFilePositions.remove(position);
    }

    protected void writeIdToChunk(@Nonnull ID id) throws IOException {
        this._idSerializer.write(id, (DataOutput)this._access);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(@Nonnull P process) {
        Object id;
        if (process.isDaemon() && (id = process.getId()) != null) {
            GeneratedProcessRegistry generatedProcessRegistry = this;
            synchronized (generatedProcessRegistry) {
                if (this._processIdToFilePosition.containsKey(id)) {
                    this.unregisterKnownProcessWith(id);
                }
            }
        }
    }

    @Nonnull
    public Set<ID> getAllIds() {
        GeneratedProcessRegistry generatedProcessRegistry = this;
        synchronized (generatedProcessRegistry) {
            try {
                boolean hasNext;
                HashSet<ID> result = new HashSet<ID>((int)(this._access.length() / (long)this._idSerializer.getChunkSize()));
                this._access.seek(0L);
                do {
                    try {
                        ID id = this.readIdFromChunk();
                        result.add(id);
                        hasNext = true;
                    }
                    catch (EOFException ignored) {
                        hasNext = false;
                    }
                } while (hasNext);
                return Collections.unmodifiableSet(result);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read stored ids from " + this._access + ".", e);
            }
        }
    }

    @Nonnull
    protected ID readIdFromChunk() throws IOException {
        return (ID)this._idSerializer.read((DataInput)this._access);
    }

    @GuardedBy(value="this")
    protected void unregisterKnownProcessWith(@Nonnull ID id) {
        Long position = this._processIdToFilePosition.get(id);
        if (position != null) {
            try {
                this._access.seek(position);
                StreamUtils.writeZeros((int)this._idSerializer.getChunkSize(), (DataOutput)this._access);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not delete id " + id + " at position " + position + " from " + this._access + ".", e);
            }
            this._processIdToFilePosition.remove(id);
            this._freeFilePositions.add(position);
        }
    }

    @Nonnegative
    @GuardedBy(value="this")
    protected long getFreePosition() {
        long result;
        Iterator<Long> i = this._freeFilePositions.iterator();
        if (i.hasNext()) {
            result = i.next();
        } else {
            try {
                result = this._access.length();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not retrieve the length of " + this._access + ".", e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        GeneratedProcessRegistry generatedProcessRegistry = this;
        synchronized (generatedProcessRegistry) {
            this._access.setLength(0L);
        }
    }

    @Nonnull
    protected static File getIdsFileFor(@Nonnull File idsFileDirectory, @Nonnegative long parentLocalProcessId) {
        return new File(idsFileDirectory, Long.toString(parentLocalProcessId));
    }

    @Nonnull
    public Iterable<GeneratedProcessRegistry<ID, P>> getKnownInstances() {
        return GeneratedProcessRegistry.getKnownInstancesFor(this._type, this._idType);
    }

    @Nonnull
    public static <ID, P extends GeneratedProcess<?, ID>> Iterable<GeneratedProcessRegistry<ID, P>> getKnownInstancesFor(final @Nonnull String type, final @Nonnull Class<ID> idType) {
        final File idsFileDirectory = GeneratedProcessRegistry.getIdsFileDirectoryFor(type);
        return new Iterable<GeneratedProcessRegistry<ID, P>>(){

            @Override
            public Iterator<GeneratedProcessRegistry<ID, P>> iterator() {
                Object[] plainIds = idsFileDirectory.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        boolean result;
                        try {
                            Long.valueOf(name);
                            result = true;
                        }
                        catch (NumberFormatException ignored) {
                            result = false;
                        }
                        return result;
                    }
                });
                CloseableIterator ids = CollectionUtils.asIterator((Object[])plainIds);
                return new ConvertingIterator<String, GeneratedProcessRegistry<ID, P>>((Iterator)ids){

                    protected GeneratedProcessRegistry<ID, P> convert(String plainId) {
                        long id = Long.valueOf(plainId);
                        return new GeneratedProcessRegistry(id, type, idType);
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        GeneratedProcessRegistry generatedProcessRegistry = this;
        synchronized (generatedProcessRegistry) {
            try {
                ResourceUtils.closeQuietly((AutoCloseable)this._access);
            }
            finally {
                this._file.delete();
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Nonnull
    protected static File getIdsFileDirectoryFor(@Nonnull String type) {
        String idsFileDirectoryPath = System.getProperty(GeneratedProcessRegistry.class + ".idsFileDirectory." + type, DEFAULT_IDS_FILE_DIRECTORY_PATH_PREFIX + "/" + type);
        File idsFileDirectory = new File(idsFileDirectoryPath);
        idsFileDirectory.mkdirs();
        if (!idsFileDirectory.isDirectory()) {
            throw new IllegalArgumentException("Illegal idsFileDirectory specified: " + idsFileDirectoryPath);
        }
        return idsFileDirectory;
    }

    protected static class WaitForEnd
    implements Runnable {
        private final P _process;
        final /* synthetic */ GeneratedProcessRegistry this$0;

        public WaitForEnd(P process) {
            this.this$0 = this$0;
            this._process = process;
        }

        @Override
        public void run() {
            try {
                this._process.waitFor();
                this.this$0.unregister(this._process);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

