/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.execution;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.echocat.jomon.runtime.logging.LogLevel;
import org.echocat.jomon.runtime.logging.Slf4jUtils;
import org.echocat.jomon.runtime.util.ByteCount;
import org.echocat.jomon.runtime.util.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Drain
extends AutoCloseable {
    @Nonnull
    public static final Drain stdout = ForOutputStream.drainForOutputStream(System.out);
    @Nonnull
    public static final Drain stderr = ForOutputStream.drainForOutputStream(System.err);
    @Nonnull
    public static final Drain noop = Noop.drainThatDoNothing();

    public void drain(@Nonnull byte[] var1, @Nonnegative int var2, @Nonnegative int var3) throws Exception;

    public static class ForLogger
    implements Drain {
        @Nonnull
        protected static final Logger DEFAULT_LOGGER = LoggerFactory.getLogger(Drain.class);
        @Nonnull
        protected static final LogLevel DEFAULT_LOG_LEVEL = LogLevel.info;
        @Nonnull
        protected static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
        @Nonnull
        protected static final ByteCount DEFAULT_BUFFER_SIZE = ByteCount.byteCountOf((String)"4k");
        @Nonnull
        private final Logger _logger;
        @Nonnull
        @GuardedBy(value="this")
        private ByteBuffer _buffer = DEFAULT_BUFFER_SIZE.allocateBuffer();
        @Nonnull
        private volatile Charset _charset = DEFAULT_CHARSET;
        @Nonnull
        private volatile LogLevel _logLevel = DEFAULT_LOG_LEVEL;

        @Nonnull
        public static ForLogger drainForLogger() {
            return ForLogger.drainForLogger((Logger)null);
        }

        @Nonnull
        public static ForLogger drainForLogger(@Nullable Class<?> clazz) {
            return ForLogger.drainForLogger(ForLogger.toLogger(clazz));
        }

        @Nonnull
        public static ForLogger drainForLogger(@Nullable String loggerName) {
            return ForLogger.drainForLogger(ForLogger.toLogger(loggerName));
        }

        @Nonnull
        public static ForLogger drainForLogger(@Nullable Logger logger) {
            return new ForLogger(logger != null ? logger : DEFAULT_LOGGER);
        }

        @Nonnull
        protected static Logger toLogger(@Nullable String loggerName) {
            return loggerName != null ? LoggerFactory.getLogger((String)loggerName) : DEFAULT_LOGGER;
        }

        @Nonnull
        protected static Logger toLogger(@Nullable Class<?> clazz) {
            return clazz != null ? LoggerFactory.getLogger(clazz) : DEFAULT_LOGGER;
        }

        public ForLogger(@Nonnull Logger logger) {
            this._logger = logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drain(@Nonnull byte[] data, @Nonnegative int offset, @Nonnegative int length) throws Exception {
            ForLogger forLogger = this;
            synchronized (forLogger) {
                this.each(data, offset, length, new Consumer<ByteBuffer, RuntimeException>(){

                    public void consume(@Nullable ByteBuffer value) {
                        ForLogger.this._buffer.put(value);
                        if (ForLogger.this.endsWithNewLine(ForLogger.this._buffer)) {
                            ForLogger.this.flush(ForLogger.this._buffer);
                        }
                    }
                });
            }
        }

        @Nonnull
        protected void each(@Nonnull byte[] data, @Nonnegative int offset, @Nonnegative int length, @Nonnull Consumer<ByteBuffer, RuntimeException> consumer) {
            int currentStart = offset;
            for (int i = offset; i < length; ++i) {
                if (data[i] != 10) continue;
                consumer.consume((Object)ByteBuffer.wrap(data, currentStart, i + 1 - currentStart));
                currentStart = i + 1;
            }
            if (length > currentStart) {
                consumer.consume((Object)ByteBuffer.wrap(data, currentStart, length - currentStart));
            }
        }

        protected boolean endsWithNewLine(@Nonnull ByteBuffer buffer) {
            return buffer.position() > 0 && buffer.get(buffer.position() - 1) == 10;
        }

        protected void flush(@Nonnull ByteBuffer buffer) {
            buffer.flip();
            CharBuffer decoded = this._charset.decode(buffer);
            Slf4jUtils.log((Logger)this._logger, (LogLevel)this._logLevel, (String)decoded.toString());
            buffer.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        public ForLogger bufferingWith(@Nonnull ByteBuffer buffer) {
            ForLogger forLogger = this;
            synchronized (forLogger) {
                this._buffer = buffer;
            }
            return this;
        }

        @Nonnull
        public ForLogger buffering(@Nonnull ByteCount bytes) {
            return this.bufferingWith(bytes.allocateBuffer());
        }

        @Nonnull
        public ForLogger buffering(@Nonnull String byteCount) {
            return this.buffering(ByteCount.byteCountOf((String)byteCount));
        }

        @Nonnull
        public ForLogger decodedBy(@Nonnull String charset) {
            return this.decodedBy(Charset.forName(charset));
        }

        @Nonnull
        public ForLogger decodedBy(@Nonnull Charset charset) {
            this._charset = charset;
            return this;
        }

        @Nonnull
        public ForLogger loggingOn(@Nonnull LogLevel level) {
            this._logLevel = level;
            return this;
        }

        @Override
        public void close() throws Exception {
        }
    }

    public static class ForOutputStream
    implements Drain {
        @Nonnull
        private final OutputStream _stream;

        @Nonnull
        public static ForOutputStream drainForOutputStream(@Nonnull OutputStream stream) {
            return new ForOutputStream(stream);
        }

        public ForOutputStream(@Nonnull OutputStream stream) {
            this._stream = stream;
        }

        @Override
        public void drain(@Nonnull byte[] buffer, @Nonnegative int offset, @Nonnegative int length) throws Exception {
            this._stream.write(buffer, offset, length);
        }

        @Override
        public void close() throws Exception {
            this._stream.close();
        }
    }

    public static class AsBuffering
    implements Drain {
        private final ByteArrayOutputStream _buffer = new ByteArrayOutputStream();

        @Nonnull
        public static AsBuffering drainThatBuffers() {
            return new AsBuffering();
        }

        @Override
        public void drain(@Nonnull byte[] buffer, @Nonnegative int offset, @Nonnegative int length) throws Exception {
            this._buffer.write(buffer, offset, length);
        }

        @Override
        public void close() throws Exception {
        }

        @Nonnull
        public byte[] toByteArray() {
            return this._buffer.toByteArray();
        }

        @Nonnull
        public String toString() {
            return this._buffer.toString();
        }

        @Nonnull
        public String toString(@Nonnull Charset charset) {
            try {
                return this._buffer.toString(charset.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Could not be.", e);
            }
        }

        @Nonnull
        public String toString(@Nonnull String charset) throws UnsupportedEncodingException {
            return this._buffer.toString(charset);
        }
    }

    public static class Noop
    implements Drain {
        @Nonnull
        public static Noop noop() {
            return Noop.drainThatDoNothing();
        }

        @Nonnull
        public static Noop drainThatDoNothing() {
            return new Noop();
        }

        @Override
        public void drain(@Nonnull byte[] buffer, @Nonnegative int offset, @Nonnegative int length) throws Exception {
        }

        @Override
        public void close() throws Exception {
        }
    }
}

