/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.execution;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.process.execution.Drain;
import org.echocat.jomon.runtime.logging.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Drains {
    @Nonnull
    private Drain _stdout = Drain.stdout;
    @Nonnull
    private Drain _stderr = Drain.stderr;

    @Nonnull
    public static Drains drains() {
        return new Drains();
    }

    @Nonnull
    public Drains stdout(@Nonnull Drain drain) {
        if (drain == null) {
            throw new NullPointerException();
        }
        this._stdout = drain;
        return this;
    }

    @Nonnull
    public Drains stderr(@Nonnull Drain drain) {
        if (drain == null) {
            throw new NullPointerException();
        }
        this._stderr = drain;
        return this;
    }

    public void setStdout(@Nonnull Drain drain) {
        this.stdout(drain);
    }

    public void setStderr(@Nonnull Drain drain) {
        this.stderr(drain);
    }

    @Nonnull
    public Drain getStdout() {
        return this.stdout();
    }

    @Nonnull
    public Drain getStderr() {
        return this.stderr();
    }

    @Nonnull
    public Drain stdout() {
        return this._stdout;
    }

    @Nonnull
    public Drain stderr() {
        return this._stderr;
    }

    @Nonnull
    public Drains forLogger(@Nullable Class<?> forClass) {
        return this.forLogger(LoggerFactory.getLogger(forClass));
    }

    @Nonnull
    public Drains forLogger(@Nullable String loggerName) {
        return this.forLogger(LoggerFactory.getLogger((String)loggerName));
    }

    @Nonnull
    public Drains forLogger(@Nullable Logger logger) {
        return this.forLogger(logger, null, null);
    }

    @Nonnull
    public Drains forLogger(@Nullable Logger logger, @Nullable LogLevel stdoutLogLevel, @Nullable LogLevel stderrLogLevel) {
        Logger targetLogger = logger != null ? logger : LoggerFactory.getLogger(this.getClass());
        this.stdout(Drain.ForLogger.drainForLogger(targetLogger).loggingOn(stdoutLogLevel != null ? stdoutLogLevel : LogLevel.info));
        this.stderr(Drain.ForLogger.drainForLogger(targetLogger).loggingOn(stderrLogLevel != null ? stderrLogLevel : LogLevel.error));
        return this;
    }
}

