/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.execution;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.execution.Drain;
import org.echocat.jomon.runtime.concurrent.ThreadUtils;
import org.echocat.jomon.runtime.io.StreamType;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputMonitor<E, ID>
extends Thread
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(OutputMonitor.class);
    @Nonnull
    private final ThreadLocal<Boolean> _alreadyInClosing = new ThreadLocal();
    @Nonnull
    private final InputStream _stream;
    @Nonnull
    private final Drain _drain;
    @Nonnull
    private final Lock _lock = new ReentrantLock();
    @Nonnull
    private final Condition _condition = this._lock.newCondition();
    private boolean _alive = true;

    public OutputMonitor(@Nonnull GeneratedProcess<E, ID> process, @Nonnull StreamType streamType, @Nonnull Drain drain) throws IOException {
        super("OutputMonitor:" + process.getId() + ":" + streamType);
        this.setDaemon(true);
        this._stream = streamType == StreamType.stdout ? process.getStdout() : process.getStderr();
        this._drain = drain;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this._lock.lockInterruptibly();
            try {
                try {
                    byte[] buf = new byte[4096];
                    int read = this._stream.read(buf);
                    while (!OutputMonitor.currentThread().isInterrupted() && read >= 0) {
                        this._drain.drain(buf, 0, read);
                        read = this._stream.read(buf);
                    }
                }
                catch (InterruptedIOException ignored) {
                    OutputMonitor.currentThread().interrupt();
                }
                catch (Exception e) {
                    if (!(e instanceof IOException) || !"Stream closed".equals(e.getMessage())) {
                        LOG.warn("Could not read from " + this._stream + ".", (Throwable)e);
                    }
                }
            }
            finally {
                try {
                    this._alive = false;
                    this._condition.signalAll();
                }
                finally {
                    this._lock.unlock();
                }
            }
        }
        catch (InterruptedException ignored) {
            OutputMonitor.currentThread().interrupt();
        }
        finally {
            ResourceUtils.closeQuietly((AutoCloseable)this._stream);
        }
    }

    @Nonnull
    @Deprecated
    public String getRecordedContent() {
        return this._drain.toString();
    }

    public void waitFor() throws InterruptedException {
        this._lock.lockInterruptibly();
        try {
            while (this._alive) {
                this._condition.await(500L, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void close() {
        if (!Boolean.TRUE.equals(this._alreadyInClosing.get())) {
            this._alreadyInClosing.set(Boolean.TRUE);
            try {
                try {
                    ResourceUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{this._stream, this._drain});
                }
                finally {
                    ThreadUtils.stop((Thread)this);
                }
            }
            finally {
                this._alreadyInClosing.remove();
            }
        }
    }
}

