/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.execution;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.process.execution.Drains;
import org.echocat.jomon.runtime.generation.Requirement;

public interface ProcessExecuter<R extends Requirement> {
    @Nonnull
    public Response execute(@Nonnull R var1) throws InterruptedException, IOException;

    @Nonnull
    public Response execute(@Nonnull R var1, @Nullable Drains var2) throws InterruptedException, IOException;

    public static class Response {
        @Nonnull
        private final String _stdout;
        @Nonnull
        private final String _stderr;
        @Nonnegative
        private final int _exitCode;

        public Response(@Nonnull String stdout, @Nonnull String stderr, @Nonnegative int exitCode) {
            this._stdout = stdout;
            this._stderr = stderr;
            this._exitCode = exitCode;
        }

        @Nonnull
        public String getStdout() {
            return this._stdout;
        }

        @Nonnull
        public String getStderr() {
            return this._stderr;
        }

        @Nonnegative
        public int getExitCode() {
            return this._exitCode;
        }

        public String toString() {
            String stderr = this.getStderr().trim();
            return "ExitCode: " + this._exitCode + "\n\n====Stdout====\n\n" + this.getStdout() + (stderr.isEmpty() ? "" : "\n\n====Stderr====\n\n" + stderr);
        }

        public boolean wasSuccessful() {
            return this.getExitCode() == 0;
        }

        public boolean hasErrorOutput() {
            return !this.getStderr().trim().isEmpty();
        }

        public boolean isStdoutMatching(@Nonnull Pattern pattern) {
            return pattern.matcher(this.getStdout()).matches();
        }

        public boolean isStdoutMatching(@Nonnull String pattern) {
            return this.isStdoutMatching(Pattern.compile(pattern));
        }

        public boolean isStderrMatching(@Nonnull Pattern pattern) {
            return pattern.matcher(this.getStderr()).matches();
        }

        public boolean isStderrMatching(@Nonnull String pattern) {
            return this.isStderrMatching(Pattern.compile(pattern));
        }
    }
}

