/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.listeners.stream;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.listeners.stream.LineBasedAndStateEnabledStreamListenerSupport;
import org.echocat.jomon.process.listeners.stream.LineBasedStreamListenerSupport;
import org.echocat.jomon.process.listeners.stream.StreamListener;
import org.echocat.jomon.process.listeners.stream.StreamListenerProvider;
import org.echocat.jomon.runtime.CollectionUtils;

public abstract class StreamListenerProviderSupport
implements StreamListenerProvider {
    @Nonnull
    private final Class<? extends LineBasedStreamListenerSupport<?, ?>> _type;
    @Nonnull
    private final String _name;
    @Nonnull
    private final Set<String> _requiredParameters;

    public StreamListenerProviderSupport(@Nonnull Class<? extends LineBasedStreamListenerSupport> type, @Nonnull String name, String ... requiredParameters) {
        this(type, name, CollectionUtils.asImmutableSet((Object[])requiredParameters));
    }

    public StreamListenerProviderSupport(@Nonnull Class<? extends LineBasedStreamListenerSupport> type, @Nonnull String name, @Nullable Iterable<String> requiredParameters) {
        this._type = type;
        this._name = name;
        this._requiredParameters = CollectionUtils.asImmutableSet(requiredParameters);
    }

    @Override
    @Nullable
    public <P extends GeneratedProcess<?, ?>> StreamListener<P> provideFor(@Nonnull Class<P> processType, @Nonnull String configuration) {
        LineBasedStreamListenerSupport<P, P> result;
        String[] parts = StringUtils.split((String)configuration, (char)'|');
        if (parts.length > 0) {
            if (this._name.equals(parts[0])) {
                Map<String, String> parameters = this.toParameters(parts);
                this.checkForRequiredParameters(parameters);
                result = this.createInstanceBy(this._type, parameters);
                this.configure(result, parameters);
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        return result != null && result.canHandleReferenceType(processType) ? result : null;
    }

    @Nonnull
    protected abstract LineBasedStreamListenerSupport<?, ?> createInstanceBy(@Nonnull Class<? extends LineBasedStreamListenerSupport<?, ?>> var1, @Nonnull Map<String, String> var2);

    protected void configure(@Nonnull LineBasedStreamListenerSupport<?, ?> instance, @Nonnull Map<String, String> parameters) {
        this.configureFormatter(instance, parameters);
        this.configureRecordProcessStarted(instance, parameters);
        this.configureRecordProcessStartupSuccessful(instance, parameters);
        this.configureRecordProcessTerminated(instance, parameters);
    }

    protected void configureFormatter(@Nonnull LineBasedStreamListenerSupport<?, ?> instance, @Nonnull Map<String, String> parameters) {
        String value = parameters.get("pattern");
        if (value != null) {
            instance.whichFormatsMessagesWith(value);
        }
    }

    protected void configureRecordProcessStarted(@Nonnull LineBasedStreamListenerSupport<?, ?> instance, @Nonnull Map<String, String> parameters) {
        if (instance instanceof LineBasedAndStateEnabledStreamListenerSupport) {
            ((LineBasedAndStateEnabledStreamListenerSupport)instance).whichRecordsProcessStart(this.getBooleanValue(parameters, "recordProcessStarted", false));
        }
    }

    protected void configureRecordProcessStartupSuccessful(@Nonnull LineBasedStreamListenerSupport<?, ?> instance, @Nonnull Map<String, String> parameters) {
        if (instance instanceof LineBasedAndStateEnabledStreamListenerSupport) {
            ((LineBasedAndStateEnabledStreamListenerSupport)instance).whichRecordsProcessStartupSuccessful(this.getBooleanValue(parameters, "recordProcessStartupSuccessful", false));
        }
    }

    protected void configureRecordProcessTerminated(@Nonnull LineBasedStreamListenerSupport<?, ?> instance, @Nonnull Map<String, String> parameters) {
        if (instance instanceof LineBasedAndStateEnabledStreamListenerSupport) {
            ((LineBasedAndStateEnabledStreamListenerSupport)instance).whichRecordsProcessTermination(this.getBooleanValue(parameters, "recordProcessTerminated", false));
        }
    }

    protected boolean getBooleanValue(@Nonnull Map<String, String> parameters, @Nonnull String key, boolean defaultValue) {
        return this.isTrue(parameters.get(key), defaultValue);
    }

    protected boolean isTrue(@Nullable String value, boolean defaultValue) {
        String trimmedValue;
        String string = trimmedValue = value != null ? value.trim() : null;
        boolean result = trimmedValue != null ? trimmedValue.isEmpty() || Boolean.TRUE.toString().equalsIgnoreCase(trimmedValue) : defaultValue;
        return result;
    }

    protected void checkForRequiredParameters(@Nonnull Map<String, String> parameters) {
        TreeSet<String> missingParameters = new TreeSet<String>();
        for (String requiredParameter : this._requiredParameters) {
            if (parameters.containsKey(requiredParameter)) continue;
            missingParameters.add(requiredParameter);
        }
        if (!missingParameters.isEmpty()) {
            throw new IllegalArgumentException("Required parameters missing: " + StringUtils.join((Object[])new Set[]{missingParameters}));
        }
    }

    @Nonnull
    protected Map<String, String> toParameters(@Nonnull String[] parts) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 1; i < parts.length; ++i) {
            String key;
            String[] part = StringUtils.split((String)parts[i], (String)"=", (int)2);
            if (part.length < 1 || (key = part[0].trim()).isEmpty()) continue;
            result.put(key, part.length >= 2 ? part[1] : "");
        }
        return result;
    }
}

