/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.listeners.stream;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.listeners.stream.CompoundStreamListenerProvider;
import org.echocat.jomon.process.listeners.stream.RedirectToConsoleStreamListener;
import org.echocat.jomon.process.listeners.stream.RedirectToLoggerStreamListener;
import org.echocat.jomon.process.listeners.stream.StreamListener;
import org.echocat.jomon.process.listeners.stream.StreamListenerProvider;
import org.echocat.jomon.runtime.io.StreamType;
import org.slf4j.Logger;

public class StreamListeners {
    private static final StreamListenerProvider PROVIDER = new CompoundStreamListenerProvider(true, new StreamListenerProvider[0]);
    public static final StreamListener<?> redirectToConsole = new ReadOnlyStreamListener(new RedirectToConsoleStreamListener());
    public static final StreamListener<?> redirectToLogger = new ReadOnlyStreamListener(new RedirectToLoggerStreamListener());

    @Nonnull
    public static <P extends GeneratedProcess<?, ?>> StreamListener<P> redirectToConsole() {
        return redirectToConsole;
    }

    @Nonnull
    public static <P extends GeneratedProcess<?, ?>> StreamListener<P> redirectToLogger() {
        return redirectToLogger;
    }

    @Nonnull
    public static <P extends GeneratedProcess<?, ?>> StreamListener<P> redirectToLogger(@Nullable Class<?> forClass) {
        return new RedirectToLoggerStreamListener(forClass);
    }

    @Nonnull
    public static <P extends GeneratedProcess<?, ?>> StreamListener<P> redirectToLogger(@Nullable String loggerName) {
        return new RedirectToLoggerStreamListener(loggerName);
    }

    @Nonnull
    public static <P extends GeneratedProcess<?, ?>> StreamListener<P> redirectToLogger(@Nullable Logger logger) {
        return new RedirectToLoggerStreamListener(logger);
    }

    @Nullable
    public static <P extends GeneratedProcess<?, ?>> StreamListener<P> streamListenerFor(@Nonnull Class<P> referenceType, @Nullable String configuration) {
        return StreamListeners.streamListenerFor(referenceType, configuration, null);
    }

    @Nullable
    public static <P extends GeneratedProcess<?, ?>> StreamListener<P> streamListenerFor(@Nonnull Class<P> referenceType, @Nullable String configuration, @Nullable StreamListener<P> fallback) {
        StreamListener<P> result = configuration != null ? PROVIDER.provideFor(referenceType, configuration) : null;
        return result != null ? result : fallback;
    }

    private StreamListeners() {
    }

    public static class ReadOnlyStreamListener<P extends GeneratedProcess<?, ?>>
    implements StreamListener<P> {
        private final StreamListener<P> _delegate;

        public ReadOnlyStreamListener(@Nonnull StreamListener<P> delegate) {
            this._delegate = delegate;
        }

        @Override
        public boolean canHandleReferenceType(@Nonnull Class<?> type) {
            return this._delegate.canHandleReferenceType(type);
        }

        @Override
        public void notifyProcessStarted(@Nonnull P process) {
            this._delegate.notifyProcessStarted(process);
        }

        @Override
        public void notifyProcessStartupDone(@Nonnull P process) {
            this._delegate.notifyProcessStartupDone(process);
        }

        @Override
        public void notifyOutput(@Nonnull P process, @Nonnull byte[] data, @Nonnegative int offset, @Nonnegative int length, @Nonnull StreamType streamType) {
            this._delegate.notifyOutput(process, data, offset, length, streamType);
        }

        @Override
        public void flushOutput(@Nonnull P process, @Nonnull StreamType streamType) {
            this._delegate.flushOutput(process, streamType);
        }

        @Override
        public void notifyProcessTerminated(@Nonnull P reference, boolean regular) {
            this._delegate.notifyProcessTerminated(reference, regular);
        }
    }
}

