/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.sigar;

import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.process.AccessDeniedException;
import org.echocat.jomon.process.GeneratedProcessRegistry;
import org.echocat.jomon.process.Signal;
import org.echocat.jomon.process.local.LocalGeneratedProcess;
import org.echocat.jomon.process.local.LocalProcess;
import org.echocat.jomon.process.local.LocalProcessQuery;
import org.echocat.jomon.process.local.LocalProcessRepository;
import org.echocat.jomon.process.sigar.SigarFacade;
import org.echocat.jomon.process.sigar.SigarFacadeFactory;
import org.echocat.jomon.process.sigar.SigarProcess;
import org.echocat.jomon.runtime.concurrent.Daemon;
import org.echocat.jomon.runtime.iterators.CloseableIterator;
import org.echocat.jomon.runtime.iterators.ConvertingIterator;
import org.echocat.jomon.runtime.iterators.IteratorUtils;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.ResourceUtils;

@ThreadSafe
public class SigarProcessRepository
extends LocalProcessRepository {
    private static final Map<Long, Long> ONE_LONG_INSTANCE = new WeakHashMap<Long, Long>();
    @Nonnull
    private final KillDaemonsOfDeadProcesses _killDaemonsOfDeadProcesses = new KillDaemonsOfDeadProcesses();
    @Nullable
    private final SigarFacade _sigar = SigarFacadeFactory.isAvialable() ? SigarFacadeFactory.create() : null;
    @Nullable
    private final GeneratedProcessRegistry<Long, LocalGeneratedProcess> _generatedProcessRegistry = this._sigar != null ? new GeneratedProcessRegistry(this._sigar.getPid(), "local", Long.class) : null;
    @Nullable
    private final Daemon _killDaemonsOfDeadProcessesDaemon = this._sigar != null ? this.startDaemon() : null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalProcess findOneBy(@Nonnull Long id) {
        SigarProcess process;
        Long idInstance;
        Map<Long, Long> map = ONE_LONG_INSTANCE;
        synchronized (map) {
            idInstance = ONE_LONG_INSTANCE.get(id);
            if (idInstance == null && id != null) {
                ONE_LONG_INSTANCE.put(id, id);
                idInstance = id;
            }
        }
        try {
            Long l = idInstance;
            synchronized (l) {
                this.getSigar().getProcState(idInstance);
            }
            process = new SigarProcess(id, this.getSigar());
        }
        catch (Exception ignored) {
            process = null;
        }
        return process;
    }

    @Nonnull
    public CloseableIterator<LocalProcess> findBy(@Nonnull LocalProcessQuery query) {
        Object result;
        List<Long> ids = query.getIds();
        if (ids != null) {
            result = new ToProcessConvertingIterator(ids);
        } else {
            try {
                result = new KnownIdsProcessIterator(this.getSigar().getProcList(), this.getSigar());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get process list for " + query + ".", e);
            }
        }
        return IteratorUtils.filter((Iterator)result, (Predicate)query);
    }

    @Override
    @Nonnull
    protected LocalGeneratedProcess toControllableProcess(@Nonnull LocalProcess placeHolder, @Nonnull Process original, boolean isDaemon) {
        LocalGeneratedProcess result = super.toControllableProcess(placeHolder, original, isDaemon);
        this._generatedProcessRegistry.register(result);
        return result;
    }

    @Override
    public void send(@Nonnull LocalProcess to, @Nonnull Signal signal) {
        int code;
        if (signal == Signal.terminate) {
            code = 15;
        } else if (signal == Signal.kill) {
            code = 9;
        } else if (signal == Signal.interrupt) {
            code = 2;
        } else {
            throw new IllegalArgumentException("Could not handle signal: " + (Object)((Object)signal));
        }
        this.getSigar().kill((long)((Long)to.getId()), code);
    }

    @Nonnull
    protected SigarFacade getSigar() {
        if (this._sigar == null) {
            throw new UnsupportedOperationException("This method is not available because sigar does not completely initialized on this platform. See previous log entries for more information.");
        }
        return this._sigar;
    }

    @Override
    public boolean isAvailable() {
        return this._sigar != null;
    }

    @Override
    public long getThisPid() {
        return this.getSigar().getPid();
    }

    @Nonnull
    protected Daemon startDaemon() {
        Daemon daemon = new Daemon((Runnable)this._killDaemonsOfDeadProcesses);
        daemon.setInterval(new Duration("1m"));
        try {
            daemon.init();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start killDaemonsOfDeadProcessesDaemon.", e);
        }
        daemon.run();
        return daemon;
    }

    @Override
    public void close() {
        try {
            ResourceUtils.closeQuietly(this._generatedProcessRegistry);
        }
        finally {
            try {
                ResourceUtils.closeQuietly((AutoCloseable)this._killDaemonsOfDeadProcessesDaemon);
            }
            finally {
                ResourceUtils.closeQuietly((AutoCloseable)this.getSigar());
            }
        }
    }

    @Nonnull
    protected static SigarProcess toProcess(long pid, @Nonnull SigarFacade sigar) {
        return new SigarProcess(pid, sigar);
    }

    protected class KillDaemonsOfDeadProcesses
    implements Runnable {
        protected KillDaemonsOfDeadProcesses() {
        }

        @Override
        public void run() {
            SigarFacade sigar = SigarProcessRepository.this.getSigar();
            if (sigar != null) {
                for (GeneratedProcessRegistry registry : GeneratedProcessRegistry.getKnownInstancesFor("local", Long.class)) {
                    if (SigarProcessRepository.this.findOneBy(registry.getParentLocalProcessId()) != null) continue;
                    for (Long processId : registry.getAllIds()) {
                        try {
                            sigar.kill((long)processId, 9);
                        }
                        catch (IllegalArgumentException | AccessDeniedException ignored) {}
                    }
                }
            }
        }
    }

    protected static class KnownIdsProcessIterator
    implements CloseableIterator<LocalProcess> {
        private final long[] _pids;
        private final SigarFacade _sigar;
        private int _index;

        public KnownIdsProcessIterator(@Nonnull long[] pids, @Nonnull SigarFacade sigar) {
            this._pids = pids;
            this._sigar = sigar;
        }

        public void close() {
        }

        public boolean hasNext() {
            return this._index < this._pids.length;
        }

        public LocalProcess next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long pid = this._pids[this._index++];
            return SigarProcessRepository.toProcess(pid, this._sigar);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class ToProcessConvertingIterator
    extends ConvertingIterator<Long, LocalProcess> {
        public ToProcessConvertingIterator(Iterable<Long> ids) {
            this(ids.iterator());
        }

        public ToProcessConvertingIterator(Iterator<Long> ids) {
            super(ids);
        }

        protected LocalProcess convert(@Nullable Long id) {
            return id != null ? SigarProcessRepository.this.findOneBy(id) : null;
        }
    }
}

