/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.ssh.jsch;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.net.ssh.Ssh;
import org.echocat.jomon.net.ssh.SshProcessRepository;
import org.echocat.jomon.net.ssh.SshSessionGenerator;
import org.echocat.jomon.net.ssh.jsch.JschSshProcessRepository;
import org.echocat.jomon.net.ssh.jsch.JschSshSessionGenerator;
import org.echocat.jomon.runtime.exceptions.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JschSsh
extends Ssh {
    private static final Logger LOG = LoggerFactory.getLogger(JschSsh.class);
    @Nullable
    private final JschSshSessionGenerator _sessionGenerator;
    @Nullable
    private final JschSshProcessRepository _processRepository;

    public JschSsh(@Nonnull JschSshSessionGenerator sessionGenerator, @Nonnull JschSshProcessRepository processRepository) {
        this._sessionGenerator = sessionGenerator;
        this._processRepository = processRepository;
    }

    public JschSsh() {
        this._sessionGenerator = this.tryCreateSessionGenerator();
        this._processRepository = this._sessionGenerator != null ? this.tryCreateProcessGenerator(this._sessionGenerator) : null;
    }

    @Nullable
    protected JschSshSessionGenerator tryCreateSessionGenerator() {
        JschSshSessionGenerator result;
        try {
            result = new JschSshSessionGenerator();
        }
        catch (Exception e) {
            result = null;
            this.checkException(e, SshSessionGenerator.class);
        }
        return result;
    }

    @Nullable
    protected JschSshProcessRepository tryCreateProcessGenerator(@Nonnull JschSshSessionGenerator sessionGenerator) {
        JschSshProcessRepository result;
        try {
            result = new JschSshProcessRepository(sessionGenerator);
        }
        catch (Exception e) {
            result = null;
            this.checkException(e, SshProcessRepository.class);
        }
        return result;
    }

    protected void checkException(@Nonnull Exception e, @Nonnull Class<?> resultType) {
        if (!ExceptionUtils.containsClassNotFoundException((Throwable)e, (String)"com.jcraft.jsch.")) {
            throw new RuntimeException("Could not create a " + resultType.getSimpleName() + ".", e);
        }
        LOG.info("The JSch implementation of " + resultType.getSimpleName() + " is not available. Could not find the JSch implementation in the classpath present. If you use Maven add the org.fusesource:sigar:1.6.4+ dependency. You can ignore this message if you do not want to use the JSch SSH implementation.");
    }

    @Override
    @Nonnull
    public SshSessionGenerator getSessionGenerator() {
        return this.returnCheckedInstance(this._sessionGenerator, SshSessionGenerator.class);
    }

    @Override
    @Nonnull
    public SshProcessRepository getProcessRepository() {
        return this.returnCheckedInstance(this._processRepository, SshProcessRepository.class);
    }

    @Nonnull
    protected <T> T returnCheckedInstance(@Nullable T instance, @Nonnull Class<T> type) {
        if (instance == null) {
            throw new UnsupportedOperationException("This implemenation of " + Ssh.class.getName() + " is not able to provide a " + type.getSimpleName() + " because there is no JSch available for this JVM. See previous message for more information.");
        }
        return instance;
    }

    @Override
    public boolean isAvailable() {
        return this._sessionGenerator != null;
    }
}

